/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.tree;

import java.util.Comparator;
import java.util.stream.Stream;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.tree.LinByteArrayTag;
import org.enginehub.linbus.tree.LinByteTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinEndTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinIntTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinLongArrayTag;
import org.enginehub.linbus.tree.LinLongTag;
import org.enginehub.linbus.tree.LinShortTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.jetbrains.annotations.NotNull;

public final class LinTagType<T extends @NotNull LinTag<?>> {
    private static final LinTagType<@NotNull LinEndTag> END_TAG = new LinTagType<LinEndTag>(LinTagId.END, LinEndTag.class);
    private static final LinTagType<@NotNull LinByteTag> BYTE_TAG = new LinTagType<LinByteTag>(LinTagId.BYTE, LinByteTag.class);
    private static final LinTagType<@NotNull LinShortTag> SHORT_TAG = new LinTagType<LinShortTag>(LinTagId.SHORT, LinShortTag.class);
    private static final LinTagType<@NotNull LinIntTag> INT_TAG = new LinTagType<LinIntTag>(LinTagId.INT, LinIntTag.class);
    private static final LinTagType<@NotNull LinLongTag> LONG_TAG = new LinTagType<LinLongTag>(LinTagId.LONG, LinLongTag.class);
    private static final LinTagType<@NotNull LinFloatTag> FLOAT_TAG = new LinTagType<LinFloatTag>(LinTagId.FLOAT, LinFloatTag.class);
    private static final LinTagType<@NotNull LinDoubleTag> DOUBLE_TAG = new LinTagType<LinDoubleTag>(LinTagId.DOUBLE, LinDoubleTag.class);
    private static final LinTagType<@NotNull LinByteArrayTag> BYTE_ARRAY_TAG = new LinTagType<LinByteArrayTag>(LinTagId.BYTE_ARRAY, LinByteArrayTag.class);
    private static final LinTagType<@NotNull LinStringTag> STRING_TAG = new LinTagType<LinStringTag>(LinTagId.STRING, LinStringTag.class);
    private static final LinTagType LIST_TAG = new LinTagType<LinListTag>(LinTagId.LIST, LinListTag.class);
    private static final LinTagType<@NotNull LinCompoundTag> COMPOUND_TAG = new LinTagType<LinCompoundTag>(LinTagId.COMPOUND, LinCompoundTag.class);
    private static final LinTagType<@NotNull LinIntArrayTag> INT_ARRAY_TAG = new LinTagType<LinIntArrayTag>(LinTagId.INT_ARRAY, LinIntArrayTag.class);
    private static final LinTagType<@NotNull LinLongArrayTag> LONG_ARRAY_TAG = new LinTagType<LinLongArrayTag>(LinTagId.LONG_ARRAY, LinLongArrayTag.class);
    @NotNull
    private static final LinTagType<?>[] LIN_TAG_TYPES = (LinTagType[])Stream.of(END_TAG, BYTE_TAG, SHORT_TAG, INT_TAG, LONG_TAG, FLOAT_TAG, DOUBLE_TAG, BYTE_ARRAY_TAG, STRING_TAG, LIST_TAG, COMPOUND_TAG, INT_ARRAY_TAG, LONG_ARRAY_TAG).sorted(Comparator.comparing(LinTagType::id)).toArray(LinTagType[]::new);
    private final LinTagId id;
    private final Class<T> javaType;

    @NotNull
    public static @NotNull LinTagType<@NotNull LinEndTag> endTag() {
        return END_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinByteTag> byteTag() {
        return BYTE_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinShortTag> shortTag() {
        return SHORT_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinIntTag> intTag() {
        return INT_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinLongTag> longTag() {
        return LONG_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinFloatTag> floatTag() {
        return FLOAT_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinDoubleTag> doubleTag() {
        return DOUBLE_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinByteArrayTag> byteArrayTag() {
        return BYTE_ARRAY_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinStringTag> stringTag() {
        return STRING_TAG;
    }

    @NotNull
    public static <T extends LinTag<?>> @NotNull LinTagType<@NotNull LinListTag<T>> listTag() {
        LinTagType cast = LIST_TAG;
        return cast;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinCompoundTag> compoundTag() {
        return COMPOUND_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinIntArrayTag> intArrayTag() {
        return INT_ARRAY_TAG;
    }

    @NotNull
    public static @NotNull LinTagType<@NotNull LinLongArrayTag> longArrayTag() {
        return LONG_ARRAY_TAG;
    }

    @NotNull
    public static <T extends LinTag<?>> LinTagType<T> fromId(LinTagId id) {
        LinTagType<?> cast = LIN_TAG_TYPES[id.id()];
        return cast;
    }

    private LinTagType(LinTagId id, Class<T> javaType) {
        this.id = id;
        this.javaType = javaType;
    }

    @NotNull
    public String name() {
        return this.id.name();
    }

    @NotNull
    public LinTagId id() {
        return this.id;
    }

    public T cast(LinTag<?> tag) {
        if (tag.type() != this) {
            throw new IllegalArgumentException("Tag is a " + tag.type().name() + ", not a " + this.name());
        }
        return (T)((LinTag)this.javaType.cast(tag));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinTagType that = (LinTagType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }
}

