/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.enginehub.linbus.stream.LinStream;
import org.enginehub.linbus.stream.internal.FlatteningLinStream;
import org.enginehub.linbus.stream.internal.SurroundingLinStream;
import org.enginehub.linbus.stream.token.LinToken;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class LinListTag<T extends @NotNull LinTag<?>>
extends LinTag<List<T>> {
    private final LinTagType<T> elementType;
    private final List<T> value;

    @NotNull
    public static <T extends LinTag<?>> LinListTag<T> of(@NotNull LinTagType<T> elementType, @NotNull List<T> value) {
        for (LinTag t : value) {
            if (t.type() == elementType) continue;
            throw new IllegalArgumentException("Element is not of type " + elementType.name() + " but " + t.type().name());
        }
        return new LinListTag<T>(elementType, List.copyOf(value));
    }

    @NotNull
    public static <T extends LinTag<?>> LinListTag<T> empty(@NotNull LinTagType<T> elementType) {
        return LinListTag.builder(elementType).build();
    }

    @NotNull
    public static <T extends LinTag<?>> Builder<T> builder(@NotNull LinTagType<T> elementType) {
        return new Builder<T>(elementType);
    }

    private LinListTag(LinTagType<T> elementType, List<T> value) {
        Objects.requireNonNull(value, "value is null");
        if (!value.isEmpty() && elementType == LinTagType.endTag()) {
            throw new IllegalArgumentException("A non-empty list cannot be of type END");
        }
        this.elementType = elementType;
        this.value = value;
    }

    @Override
    @NotNull
    public @NotNull LinTagType<@NotNull LinListTag<T>> type() {
        return LinTagType.listTag();
    }

    @NotNull
    public LinTagType<T> elementType() {
        return this.elementType;
    }

    public <U extends LinTag<?>> LinListTag<U> asTypeChecked(@NotNull LinTagType<U> elementType) {
        if (elementType != this.elementType) {
            throw new IllegalStateException("List is of type " + this.elementType.name() + ", not " + elementType.name());
        }
        LinListTag cast = this;
        return cast;
    }

    @Override
    @NotNull
    public List<T> value() {
        return this.value;
    }

    @Override
    @NotNull
    public LinStream linStream() {
        return new SurroundingLinStream(new LinToken.ListStart(this.value.size(), this.elementType.id()), new FlatteningLinStream(this.value.iterator()), new LinToken.ListEnd());
    }

    public T get(int index) {
        return (T)((LinTag)this.value.get(index));
    }

    @NotNull
    public Builder<T> toBuilder() {
        return new Builder(this);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + this.value;
    }

    public static final class Builder<T extends @NotNull LinTag<?>> {
        private final LinTagType<T> elementType;
        private final List<T> collector;

        private Builder(LinTagType<T> elementType) {
            this.elementType = elementType;
            this.collector = new ArrayList<T>();
        }

        private Builder(LinListTag<T> base) {
            this.elementType = base.elementType;
            this.collector = new ArrayList(base.value);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> add(T tag) {
            if (((LinTag)tag).type() != this.elementType) {
                throw new IllegalArgumentException("Element is not of type " + this.elementType.name() + " but " + ((LinTag)tag).type().name());
            }
            this.collector.add(tag);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> addAll(@NotNull Collection<? extends T> tags) {
            tags.forEach(this::add);
            return this;
        }

        @NotNull
        public LinListTag<T> build() {
            return new LinListTag<T>(this.elementType, List.copyOf(this.collector));
        }
    }
}

