/*
 * Decompiled with CFR 0.152.
 */
package io.github.repooper.packetevents.bstats;

import io.github.repooper.packetevents.bstats.Metrics$CustomChart;
import io.github.repooper.packetevents.bstats.Metrics$JsonObjectBuilder;
import io.github.repooper.packetevents.bstats.Metrics$MetricsBase;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Level;
import me.frep.vulcan.spigot.Vulcan_d;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Metrics {
    private final Plugin plugin;
    private final Metrics$MetricsBase metricsBase;
    private static final long a = Vulcan_d.a(-7597186782235044112L, -1006235440800907958L, MethodHandles.lookup().lookupClass()).a(262102548612903L);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Metrics(JavaPlugin javaPlugin, int n) {
        this.plugin = javaPlugin;
        File file = new File(javaPlugin.getDataFolder().getParentFile(), "bStats");
        File file2 = new File(file, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
        try {
            if (!yamlConfiguration.isSet("serverUuid")) {
                yamlConfiguration.addDefault("enabled", (Object)true);
                yamlConfiguration.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
                yamlConfiguration.addDefault("logFailedRequests", (Object)false);
                yamlConfiguration.addDefault("logSentData", (Object)false);
                yamlConfiguration.addDefault("logResponseStatusText", (Object)false);
                yamlConfiguration.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
                try {
                    yamlConfiguration.save(file2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw Metrics.a(runtimeException);
        }
        boolean bl = yamlConfiguration.getBoolean("enabled", true);
        String string = yamlConfiguration.getString("serverUuid");
        boolean bl2 = yamlConfiguration.getBoolean("logFailedRequests", false);
        boolean bl3 = yamlConfiguration.getBoolean("logSentData", false);
        boolean bl4 = yamlConfiguration.getBoolean("logResponseStatusText", false);
        this.metricsBase = new Metrics$MetricsBase("bukkit", string, n, bl, this::appendPlatformData, this::appendServiceData, arg_0 -> Metrics.lambda$new$0(javaPlugin, arg_0), () -> ((JavaPlugin)javaPlugin).isEnabled(), this::lambda$new$1, this::lambda$new$2, bl2, bl3, bl4);
    }

    public void addCustomChart(Metrics$CustomChart metrics$CustomChart) {
        this.metricsBase.Vulcan_K(new Object[]{metrics$CustomChart});
    }

    private void appendPlatformData(Metrics$JsonObjectBuilder metrics$JsonObjectBuilder) {
        int n;
        String string;
        Metrics$JsonObjectBuilder metrics$JsonObjectBuilder2;
        long l;
        long l2 = l = a ^ 0xD180D0D72BDL;
        long l3 = l2 ^ 0x613B77C72B7FL;
        long l4 = l2 ^ 0x2DE568749D61L;
        try {
            Object[] objectArray = new Object[3];
            objectArray[2] = this.getPlayerAmount();
            objectArray[1] = "playerAmount";
            objectArray[0] = l3;
            metrics$JsonObjectBuilder.Vulcan_F(objectArray);
            metrics$JsonObjectBuilder2 = metrics$JsonObjectBuilder;
            string = "onlineMode";
            n = Bukkit.getOnlineMode() ? 1 : 0;
        }
        catch (RuntimeException runtimeException) {
            throw Metrics.a(runtimeException);
        }
        Object[] objectArray = new Object[3];
        objectArray[2] = n;
        objectArray[1] = string;
        objectArray[0] = l3;
        metrics$JsonObjectBuilder2.Vulcan_F(objectArray);
        Object[] objectArray2 = new Object[3];
        objectArray2[2] = Bukkit.getVersion();
        objectArray2[1] = l4;
        objectArray2[0] = "bukkitVersion";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray2);
        Object[] objectArray3 = new Object[3];
        objectArray3[2] = Bukkit.getName();
        objectArray3[1] = l4;
        objectArray3[0] = "bukkitName";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray3);
        Object[] objectArray4 = new Object[3];
        objectArray4[2] = System.getProperty("java.version");
        objectArray4[1] = l4;
        objectArray4[0] = "javaVersion";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray4);
        Object[] objectArray5 = new Object[3];
        objectArray5[2] = System.getProperty("os.name");
        objectArray5[1] = l4;
        objectArray5[0] = "osName";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray5);
        Object[] objectArray6 = new Object[3];
        objectArray6[2] = System.getProperty("os.arch");
        objectArray6[1] = l4;
        objectArray6[0] = "osArch";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray6);
        Object[] objectArray7 = new Object[3];
        objectArray7[2] = System.getProperty("os.version");
        objectArray7[1] = l4;
        objectArray7[0] = "osVersion";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray7);
        Object[] objectArray8 = new Object[3];
        objectArray8[2] = Runtime.getRuntime().availableProcessors();
        objectArray8[1] = "coreCount";
        objectArray8[0] = l3;
        metrics$JsonObjectBuilder.Vulcan_F(objectArray8);
    }

    private void appendServiceData(Metrics$JsonObjectBuilder metrics$JsonObjectBuilder) {
        long l = a ^ 0x3AF54D46A2BFL;
        long l2 = l ^ 0x1A08283F4D63L;
        Object[] objectArray = new Object[3];
        objectArray[2] = this.plugin.getDescription().getVersion();
        objectArray[1] = l2;
        objectArray[0] = "pluginVersion";
        metrics$JsonObjectBuilder.Vulcan_e(objectArray);
    }

    private int getPlayerAmount() {
        try {
            int n;
            Method method = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            try {
                n = method.getReturnType().equals(Collection.class) ? ((Collection)method.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])method.invoke((Object)Bukkit.getServer(), new Object[0])).length;
            }
            catch (Exception exception) {
                throw Metrics.a(exception);
            }
            return n;
        }
        catch (Exception exception) {
            return Bukkit.getOnlinePlayers().size();
        }
    }

    private void lambda$new$2(String string) {
        this.plugin.getLogger().log(Level.INFO, string);
    }

    private void lambda$new$1(String string, Throwable throwable) {
        this.plugin.getLogger().log(Level.WARNING, string, throwable);
    }

    private static void lambda$new$0(JavaPlugin javaPlugin, Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)javaPlugin, runnable);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

