/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.slf4j;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import me.angeschossen.upgradeablespawners.slf4j.ILoggerFactory;
import me.angeschossen.upgradeablespawners.slf4j.Logger;
import me.angeschossen.upgradeablespawners.slf4j.event.SubstituteLoggingEvent;
import me.angeschossen.upgradeablespawners.slf4j.helpers.NOPLoggerFactory;
import me.angeschossen.upgradeablespawners.slf4j.helpers.SubstituteLogger;
import me.angeschossen.upgradeablespawners.slf4j.helpers.SubstituteLoggerFactory;
import me.angeschossen.upgradeablespawners.slf4j.helpers.Util;
import me.angeschossen.upgradeablespawners.slf4j.impl.StaticLoggerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerFactory {
    static final String gi = "http://www.slf4j.org/codes.html";
    static final String gj = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String gk = "http://www.slf4j.org/codes.html#multiple_bindings";
    static final String gl = "http://www.slf4j.org/codes.html#null_LF";
    static final String gm = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String gn = "http://www.slf4j.org/codes.html#substituteLogger";
    static final String go = "http://www.slf4j.org/codes.html#loggerNameMismatch";
    static final String gp = "http://www.slf4j.org/codes.html#replay";
    static final String gq = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String gr = "org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final int gs = 0;
    static final int gt = 1;
    static final int gu = 2;
    static final int gv = 3;
    static final int gw = 4;
    static volatile int gx = 0;
    static final SubstituteLoggerFactory gy = new SubstituteLoggerFactory();
    static final NOPLoggerFactory gz = new NOPLoggerFactory();
    static final String gA = "slf4j.detectLoggerNameMismatch";
    static final String gB = "java.vendor.url";
    static boolean gC = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    private static final String[] gD = new String[]{"1.6", "1.7"};
    private static String gE = "me/angeschossen/upgradeablespawners/slf4j/impl/StaticLoggerBinder.class";

    private LoggerFactory() {
    }

    static void WYSDv() {
        gx = 0;
    }

    private static final void BHVB() {
        LoggerFactory.FVKbg();
        if (gx == 3) {
            LoggerFactory.ZpSye();
        }
    }

    private static boolean tUXxG(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains("me/angeschossen/upgradeablespawners/slf4j/impl/StaticLoggerBinder")) {
            return true;
        }
        return string.contains("me.angeschossen.upgradeablespawners.slf4j.impl.StaticLoggerBinder");
    }

    private static final void FVKbg() {
        block11: {
            try {
                Set<URL> set = null;
                if (!LoggerFactory.hOjzA()) {
                    set = LoggerFactory.gECGV();
                    LoggerFactory.OqjOn(set);
                }
                StaticLoggerBinder.getSingleton();
                gx = 3;
                LoggerFactory.QmAmI(set);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string = noClassDefFoundError.getMessage();
                if (LoggerFactory.tUXxG(string)) {
                    gx = 4;
                    Util.report("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                    Util.report("Defaulting to no-operation (NOP) logger implementation");
                    Util.report("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
                    break block11;
                }
                LoggerFactory.DYOUE(noClassDefFoundError);
                throw noClassDefFoundError;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                String string = noSuchMethodError.getMessage();
                if (string != null && string.contains("me.angeschossen.upgradeablespawners.slf4j.impl.StaticLoggerBinder.getSingleton()")) {
                    gx = 2;
                    Util.report("slf4j-api 1.6.x (or later) is incompatible with this binding.");
                    Util.report("Your binding is version 1.5.5 or earlier.");
                    Util.report("Upgrade your binding to version 1.6.x.");
                }
                throw noSuchMethodError;
            }
            catch (Exception exception) {
                LoggerFactory.DYOUE(exception);
                throw new IllegalStateException("Unexpected initialization failure", exception);
            }
            finally {
                LoggerFactory.MxqvH();
            }
        }
    }

    private static void MxqvH() {
        LoggerFactory.niboa();
        LoggerFactory.YRqbB();
        gy.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void niboa() {
        SubstituteLoggerFactory substituteLoggerFactory = gy;
        synchronized (substituteLoggerFactory) {
            gy.postInitialization();
            for (SubstituteLogger substituteLogger : gy.getLoggers()) {
                Logger logger = LoggerFactory.getLogger(substituteLogger.getName());
                substituteLogger.setDelegate(logger);
            }
        }
    }

    static void DYOUE(Throwable throwable) {
        gx = 2;
        Util.report("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    private static void YRqbB() {
        int n;
        LinkedBlockingQueue<SubstituteLoggingEvent> linkedBlockingQueue = gy.getEventQueue();
        int n2 = linkedBlockingQueue.size();
        int n3 = 0;
        int n4 = 128;
        ArrayList arrayList = new ArrayList(128);
        while ((n = linkedBlockingQueue.drainTo(arrayList, 128)) != 0) {
            for (SubstituteLoggingEvent substituteLoggingEvent : arrayList) {
                LoggerFactory.vevKK(substituteLoggingEvent);
                if (n3++ != 0) continue;
                LoggerFactory.vevKK(substituteLoggingEvent, n2);
            }
            arrayList.clear();
        }
    }

    private static void vevKK(SubstituteLoggingEvent substituteLoggingEvent, int n) {
        if (substituteLoggingEvent.getLogger().isDelegateEventAware()) {
            LoggerFactory.cUQq(n);
        } else if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.EuzKu();
        }
    }

    private static void vevKK(SubstituteLoggingEvent substituteLoggingEvent) {
        if (substituteLoggingEvent == null) {
            return;
        }
        SubstituteLogger substituteLogger = substituteLoggingEvent.getLogger();
        String string = substituteLogger.getName();
        if (substituteLogger.isDelegateNull()) {
            throw new IllegalStateException("Delegate logger cannot be null at this state.");
        }
        if (!substituteLogger.isDelegateNOP()) {
            if (substituteLogger.isDelegateEventAware()) {
                substituteLogger.log(substituteLoggingEvent);
            } else {
                Util.report(string);
            }
        }
    }

    private static void EuzKu() {
        Util.report("The following set of substitute loggers may have been accessed");
        Util.report("during the initialization phase. Logging calls during this");
        Util.report("phase were not honored. However, subsequent logging calls to these");
        Util.report("loggers will work as normally expected.");
        Util.report("See also http://www.slf4j.org/codes.html#substituteLogger");
    }

    private static void cUQq(int n) {
        Util.report("A number (" + n + ") of logging calls during the initialization phase have been intercepted and are");
        Util.report("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Util.report("See also http://www.slf4j.org/codes.html#replay");
    }

    private static final void ZpSye() {
        try {
            String string = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean bl = false;
            for (String string2 : gD) {
                if (!string.startsWith(string2)) continue;
                bl = true;
            }
            if (!bl) {
                Util.report("The requested version " + string + " by your slf4j binding is not compatible with " + Arrays.asList(gD).toString());
                Util.report("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
        }
        catch (Throwable throwable) {
            Util.report("Unexpected problem occured during version sanity check", throwable);
        }
    }

    static Set<URL> gECGV() {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        try {
            ClassLoader classLoader = LoggerFactory.class.getClassLoader();
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(gE) : classLoader.getResources(gE);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                linkedHashSet.add(uRL);
            }
        }
        catch (IOException iOException) {
            Util.report("Error getting resources from path", iOException);
        }
        return linkedHashSet;
    }

    private static boolean NJSja(Set<URL> set) {
        return set.size() > 1;
    }

    private static void OqjOn(Set<URL> set) {
        if (LoggerFactory.NJSja(set)) {
            Util.report("Class path contains multiple SLF4J bindings.");
            for (URL uRL : set) {
                Util.report("Found binding in [" + uRL + "]");
            }
            Util.report("See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    private static boolean hOjzA() {
        String string = Util.safeGetSystemProperty(gB);
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains("android");
    }

    private static void QmAmI(Set<URL> set) {
        if (set != null && LoggerFactory.NJSja(set)) {
            Util.report("Actual binding is of type [" + StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr() + "]");
        }
    }

    public static Logger getLogger(String string) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (gC && (clazz2 = Util.getCallingClass()) != null && LoggerFactory.vevKK(clazz, clazz2)) {
            Util.report(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), clazz2.getName()));
            Util.report("See http://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    private static boolean vevKK(Class<?> clazz, Class<?> clazz2) {
        return !clazz2.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ILoggerFactory getILoggerFactory() {
        if (gx == 0) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : me.angeschossen.upgradeablespawners.slf4j.LoggerFactory.class
            if (gx == 0) {
                gx = 1;
                LoggerFactory.BHVB();
            }
            // MONITOREXIT : clazz
        }
        switch (gx) {
            case 3: {
                return StaticLoggerBinder.getSingleton().getLoggerFactory();
            }
            case 4: {
                return gz;
            }
            case 2: {
                throw new IllegalStateException(gr);
            }
            case 1: {
                return gy;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }
}

