/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import me.angeschossen.upgradeablespawners.hikari.util.ClockSource;
import me.angeschossen.upgradeablespawners.hikari.util.FastList;
import me.angeschossen.upgradeablespawners.slf4j.Logger;
import me.angeschossen.upgradeablespawners.slf4j.LoggerFactory;

public class ConcurrentBag<T extends IConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger eH = LoggerFactory.getLogger(ConcurrentBag.class);
    private final CopyOnWriteArrayList<T> eI;
    private final boolean eJ;
    private final ThreadLocal<List<Object>> eK;
    private final IBagStateListener eL;
    private final AtomicInteger eM;
    private volatile boolean eN;
    private final SynchronousQueue<T> eO;

    public ConcurrentBag(IBagStateListener iBagStateListener) {
        this.eL = iBagStateListener;
        this.eJ = this.xotm();
        this.eO = new SynchronousQueue(true);
        this.eM = new AtomicInteger();
        this.eI = new CopyOnWriteArrayList();
        this.eK = this.eJ ? ThreadLocal.withInitial(() -> new ArrayList(16)) : ThreadLocal.withInitial(() -> new FastList(IConcurrentBagEntry.class, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrow(long l, TimeUnit timeUnit) {
        int n;
        List<Object> list = this.eK.get();
        for (n = list.size() - 1; n >= 0; --n) {
            IConcurrentBagEntry iConcurrentBagEntry;
            Iterator<T> iterator = list.remove(n);
            IConcurrentBagEntry iConcurrentBagEntry2 = iConcurrentBagEntry = this.eJ ? (IConcurrentBagEntry)((WeakReference)((Object)iterator)).get() : (IConcurrentBagEntry)((Object)iterator);
            if (iConcurrentBagEntry == null || !iConcurrentBagEntry.compareAndSet(0, 1)) continue;
            return (T)iConcurrentBagEntry;
        }
        n = this.eM.incrementAndGet();
        try {
            long l2;
            for (IConcurrentBagEntry iConcurrentBagEntry : this.eI) {
                if (!iConcurrentBagEntry.compareAndSet(0, 1)) continue;
                if (n > 1) {
                    this.eL.addBagItem(n - 1);
                }
                IConcurrentBagEntry iConcurrentBagEntry3 = iConcurrentBagEntry;
                return (T)iConcurrentBagEntry3;
            }
            this.eL.addBagItem(n);
            l = timeUnit.toNanos(l);
            do {
                l2 = ClockSource.currentTime();
                IConcurrentBagEntry iConcurrentBagEntry = (IConcurrentBagEntry)this.eO.poll(l, TimeUnit.NANOSECONDS);
                if (iConcurrentBagEntry != null && !iConcurrentBagEntry.compareAndSet(0, 1)) continue;
                IConcurrentBagEntry iConcurrentBagEntry4 = iConcurrentBagEntry;
                return (T)iConcurrentBagEntry4;
            } while ((l -= ClockSource.elapsedNanos(l2)) > 10000L);
            T t = null;
            return t;
        }
        finally {
            this.eM.decrementAndGet();
        }
    }

    public void requite(T t) {
        t.setState(0);
        int n = 0;
        while (this.eM.get() > 0) {
            if (t.getState() != 0 || this.eO.offer(t)) {
                return;
            }
            if ((n & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++n;
        }
        List<Object> list = this.eK.get();
        if (list.size() < 50) {
            list.add(this.eJ ? new WeakReference<T>(t) : t);
        }
    }

    public void add(T t) {
        if (this.eN) {
            eH.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.eI.add(t);
        while (this.eM.get() > 0 && t.getState() == 0 && !this.eO.offer(t)) {
            Thread.yield();
        }
    }

    public boolean remove(T t) {
        if (!(t.compareAndSet(1, -1) || t.compareAndSet(-2, -1) || this.eN)) {
            eH.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)t);
            return false;
        }
        boolean bl = this.eI.remove(t);
        if (!bl && !this.eN) {
            eH.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)t);
        }
        this.eK.get().remove(t);
        return bl;
    }

    @Override
    public void close() {
        this.eN = true;
    }

    public List<T> values(int n) {
        List list = this.eI.stream().filter(iConcurrentBagEntry -> iConcurrentBagEntry.getState() == n).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List<T> values() {
        return (List)this.eI.clone();
    }

    public boolean reserve(T t) {
        return t.compareAndSet(0, -2);
    }

    public void unreserve(T t) {
        if (t.compareAndSet(-2, 0)) {
            while (this.eM.get() > 0 && !this.eO.offer(t)) {
                Thread.yield();
            }
        } else {
            eH.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)t);
        }
    }

    public int getWaitingThreadCount() {
        return this.eM.get();
    }

    public int getCount(int n) {
        int n2 = 0;
        for (IConcurrentBagEntry iConcurrentBagEntry : this.eI) {
            if (iConcurrentBagEntry.getState() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int[] getStateCounts() {
        int[] nArray = new int[6];
        for (IConcurrentBagEntry iConcurrentBagEntry : this.eI) {
            int n = iConcurrentBagEntry.getState();
            nArray[n] = nArray[n] + 1;
        }
        nArray[4] = this.eI.size();
        nArray[5] = this.eM.get();
        return nArray;
    }

    public int size() {
        return this.eI.size();
    }

    public void dumpState() {
        this.eI.forEach(iConcurrentBagEntry -> eH.info(iConcurrentBagEntry.toString()));
    }

    private boolean xotm() {
        try {
            if (System.getProperty("me.angeschossen.upgradeablespawners.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("me.angeschossen.upgradeablespawners.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    public static interface IBagStateListener {
        public void addBagItem(int var1);
    }

    public static interface IConcurrentBagEntry {
        public static final int STATE_NOT_IN_USE = 0;
        public static final int STATE_IN_USE = 1;
        public static final int STATE_REMOVED = -1;
        public static final int STATE_RESERVED = -2;

        public boolean compareAndSet(int var1, int var2);

        public void setState(int var1);

        public int getState();
    }
}

