/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import me.angeschossen.upgradeablespawners.hikari.SQLExceptionOverride;
import me.angeschossen.upgradeablespawners.hikari.pool.PoolEntry;
import me.angeschossen.upgradeablespawners.hikari.pool.ProxyFactory;
import me.angeschossen.upgradeablespawners.hikari.pool.ProxyLeakTask;
import me.angeschossen.upgradeablespawners.hikari.util.ClockSource;
import me.angeschossen.upgradeablespawners.hikari.util.FastList;
import me.angeschossen.upgradeablespawners.slf4j.Logger;
import me.angeschossen.upgradeablespawners.slf4j.LoggerFactory;

public abstract class ProxyConnection
implements Connection {
    static final int ee = 1;
    static final int ef = 2;
    static final int eg = 4;
    static final int eh = 8;
    static final int ei = 16;
    static final int ej = 32;
    private static final Logger ek = LoggerFactory.getLogger(ProxyConnection.class);
    private static final Set<String> el = new HashSet<String>();
    private static final Set<Integer> em;
    protected Connection delegate;
    private final PoolEntry en;
    private final ProxyLeakTask eo;
    private final FastList<Statement> ep;
    private int eq;
    private long er;
    private boolean es;
    private boolean aY;
    private boolean aX;
    private int dD;
    private int dH;
    private String et;
    private String eu;

    protected ProxyConnection(PoolEntry poolEntry, Connection connection, FastList<Statement> fastList, ProxyLeakTask proxyLeakTask, long l, boolean bl, boolean bl2) {
        this.en = poolEntry;
        this.delegate = connection;
        this.ep = fastList;
        this.eo = proxyLeakTask;
        this.er = l;
        this.aY = bl;
        this.aX = bl2;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + " wrapping " + this.delegate;
    }

    final boolean gqFj() {
        return this.aX;
    }

    final String uznoQ() {
        return this.et;
    }

    final String pgVgq() {
        return this.eu;
    }

    final int zPttp() {
        return this.dH;
    }

    final boolean UHsEs() {
        return this.aY;
    }

    final int QAYJ() {
        return this.dD;
    }

    final PoolEntry gcVPw() {
        return this.en;
    }

    final SQLException vevKK(SQLException sQLException) {
        boolean bl = false;
        SQLException sQLException2 = sQLException;
        SQLExceptionOverride sQLExceptionOverride = this.en.QRgPs().dy;
        for (int n = 0; this.delegate != ClosedConnection.ev && sQLException2 != null && n < 10; sQLException2 = sQLException2.getNextException(), ++n) {
            String string = sQLException2.getSQLState();
            if ((string == null || !string.startsWith("08")) && !(sQLException2 instanceof SQLTimeoutException) && !el.contains(string) && !em.contains(sQLException2.getErrorCode())) continue;
            if (sQLExceptionOverride != null && sQLExceptionOverride.adjudicate(sQLException2) == SQLExceptionOverride.Override.DO_NOT_EVICT) break;
            bl = true;
            break;
        }
        if (bl) {
            SQLException sQLException3 = sQLException2 != null ? sQLException2 : sQLException;
            ek.warn("{} - Connection {} marked as broken because of SQLSTATE({}), ErrorCode({})", this.en.getPoolName(), this.delegate, sQLException3.getSQLState(), sQLException3.getErrorCode(), sQLException3);
            this.eo.cancel();
            this.en.kuKbc("(connection is broken)");
            this.delegate = ClosedConnection.ev;
        }
        return sQLException;
    }

    final synchronized void vevKK(Statement statement) {
        this.ep.remove(statement);
    }

    final void TtEln() {
        if (this.aX) {
            this.er = ClockSource.currentTime();
        } else {
            this.es = true;
        }
    }

    void frHgG() {
        this.eo.cancel();
    }

    private synchronized <T extends Statement> T NJSja(T t) {
        this.ep.add(t);
        return t;
    }

    private synchronized void LoZdj() {
        int n = this.ep.size();
        if (n > 0) {
            for (int i = 0; i < n && this.delegate != ClosedConnection.ev; ++i) {
                try {
                    Statement statement = this.ep.get(i);
                    if (statement == null) continue;
                    statement.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    ek.warn("{} - Connection {} marked as broken because of an exception closing open statements during Connection.close()", (Object)this.en.getPoolName(), (Object)this.delegate);
                    this.eo.cancel();
                    this.en.kuKbc("(exception closing Statements during Connection.close())");
                    this.delegate = ClosedConnection.ev;
                }
            }
            this.ep.clear();
        }
    }

    @Override
    public final void close() {
        this.LoZdj();
        if (this.delegate != ClosedConnection.ev) {
            this.eo.cancel();
            try {
                if (this.es && !this.aX) {
                    this.delegate.rollback();
                    this.er = ClockSource.currentTime();
                    ek.debug("{} - Executed rollback on connection {} due to dirty commit state on close().", (Object)this.en.getPoolName(), (Object)this.delegate);
                }
                if (this.eq != 0) {
                    this.en.vevKK(this, this.eq);
                    this.er = ClockSource.currentTime();
                }
                this.delegate.clearWarnings();
            }
            catch (SQLException sQLException) {
                if (!this.en.kZcwS()) {
                    throw this.vevKK(sQLException);
                }
            }
            finally {
                this.delegate = ClosedConnection.ev;
                this.en.mBOwQ(this.er);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.delegate == ClosedConnection.ev;
    }

    @Override
    public Statement createStatement() {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.createStatement()));
    }

    @Override
    public Statement createStatement(int n, int n2) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.createStatement(n, n2)));
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.createStatement(n, n2, n3)));
    }

    @Override
    public CallableStatement prepareCall(String string) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareCall(string)));
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareCall(string, n, n2)));
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareCall(string, n, n2, n3)));
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareStatement(string)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareStatement(string, n)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareStatement(string, n, n2)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareStatement(string, n, n2, n3)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareStatement(string, nArray)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        return ProxyFactory.vevKK(this, this.NJSja(this.delegate.prepareStatement(string, stringArray)));
    }

    @Override
    public DatabaseMetaData getMetaData() {
        this.TtEln();
        return ProxyFactory.vevKK(this, this.delegate.getMetaData());
    }

    @Override
    public void commit() {
        this.delegate.commit();
        this.es = false;
        this.er = ClockSource.currentTime();
    }

    @Override
    public void rollback() {
        this.delegate.rollback();
        this.es = false;
        this.er = ClockSource.currentTime();
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.delegate.rollback(savepoint);
        this.es = false;
        this.er = ClockSource.currentTime();
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.delegate.setAutoCommit(bl);
        this.aX = bl;
        this.eq |= 2;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.delegate.setReadOnly(bl);
        this.aY = bl;
        this.es = false;
        this.eq |= 1;
    }

    @Override
    public void setTransactionIsolation(int n) {
        this.delegate.setTransactionIsolation(n);
        this.dH = n;
        this.eq |= 4;
    }

    @Override
    public void setCatalog(String string) {
        this.delegate.setCatalog(string);
        this.et = string;
        this.eq |= 8;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) {
        this.delegate.setNetworkTimeout(executor, n);
        this.dD = n;
        this.eq |= 0x10;
    }

    @Override
    public void setSchema(String string) {
        this.delegate.setSchema(string);
        this.eu = string;
        this.eq |= 0x20;
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this.delegate) || this.delegate != null && this.delegate.isWrapperFor(clazz);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped connection is not an instance of " + clazz);
    }

    static {
        el.add("0A000");
        el.add("57P01");
        el.add("57P02");
        el.add("57P03");
        el.add("01002");
        el.add("JZ0C0");
        el.add("JZ0C1");
        em = new HashSet<Integer>();
        em.add(500150);
        em.add(2399);
    }

    private static final class ClosedConnection {
        static final Connection ev = ClosedConnection.iFrEw();

        private ClosedConnection() {
        }

        private static Connection iFrEw() {
            InvocationHandler invocationHandler = (object, method, objectArray) -> {
                String string = method.getName();
                if ("isClosed".equals(string)) {
                    return Boolean.TRUE;
                }
                if ("isValid".equals(string)) {
                    return Boolean.FALSE;
                }
                if ("abort".equals(string)) {
                    return Void.TYPE;
                }
                if ("close".equals(string)) {
                    return Void.TYPE;
                }
                if ("toString".equals(string)) {
                    return ClosedConnection.class.getCanonicalName();
                }
                throw new SQLException("Connection is closed");
            };
            return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, invocationHandler);
        }
    }
}

