/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.pool;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.angeschossen.upgradeablespawners.hikari.HikariConfig;
import me.angeschossen.upgradeablespawners.hikari.SQLExceptionOverride;
import me.angeschossen.upgradeablespawners.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablespawners.hikari.pool.HikariPool;
import me.angeschossen.upgradeablespawners.hikari.pool.PoolEntry;
import me.angeschossen.upgradeablespawners.hikari.pool.ProxyConnection;
import me.angeschossen.upgradeablespawners.hikari.util.ClockSource;
import me.angeschossen.upgradeablespawners.hikari.util.DriverDataSource;
import me.angeschossen.upgradeablespawners.hikari.util.PropertyElf;
import me.angeschossen.upgradeablespawners.hikari.util.UtilityElf;
import me.angeschossen.upgradeablespawners.slf4j.Logger;
import me.angeschossen.upgradeablespawners.slf4j.LoggerFactory;

abstract class PoolBase {
    private final Logger dv = LoggerFactory.getLogger(PoolBase.class);
    public final HikariConfig config;
    IMetricsTrackerDelegate dw;
    protected final String poolName;
    volatile String aE;
    final AtomicReference<Exception> dx;
    long aF;
    long aG;
    SQLExceptionOverride dy;
    private static final String[] dz = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout", "schema"};
    private static final int dA = -1;
    private static final int dB = 1;
    private static final int dC = 0;
    private int dD;
    private int dE;
    private int dF;
    private int dG;
    private int dH;
    private Executor dI;
    private DataSource bc;
    private final String dJ;
    private final boolean dK;
    private final boolean dL;
    private final boolean dM;
    private final boolean dN;
    private volatile boolean dO;

    PoolBase(HikariConfig hikariConfig) {
        this.config = hikariConfig;
        this.dD = -1;
        this.aE = hikariConfig.getCatalog();
        this.dJ = hikariConfig.getSchema();
        this.dK = hikariConfig.isReadOnly();
        this.dL = hikariConfig.isAutoCommit();
        this.dy = UtilityElf.createInstance(hikariConfig.getExceptionOverrideClassName(), SQLExceptionOverride.class, new Object[0]);
        this.dH = UtilityElf.getTransactionIsolation(hikariConfig.getTransactionIsolation());
        this.dF = -1;
        this.dE = -1;
        this.dM = hikariConfig.getConnectionTestQuery() == null;
        this.dN = hikariConfig.isIsolateInternalQueries();
        this.poolName = hikariConfig.getPoolName();
        this.aF = hikariConfig.getConnectionTimeout();
        this.aG = hikariConfig.getValidationTimeout();
        this.dx = new AtomicReference();
        this.BYoXQ();
    }

    public String toString() {
        return this.poolName;
    }

    abstract void vevKK(PoolEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void NJSja(Connection connection, String string) {
        if (connection != null) {
            try {
                this.dv.debug("{} - Closing connection {}: {}", this.poolName, connection, string);
                try {
                    this.NJSja(connection, TimeUnit.SECONDS.toMillis(15L));
                }
                catch (SQLException sQLException) {
                }
                finally {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.dv.debug("{} - Closing connection {} failed", this.poolName, connection, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean vevKK(Connection connection) {
        try {
            try {
                this.NJSja(connection, this.aG);
                int n = (int)Math.max(1000L, this.aG) / 1000;
                if (this.dM) {
                    boolean bl = connection.isValid(n);
                    return bl;
                }
                try (Statement statement = connection.createStatement();){
                    if (this.dE != 1) {
                        this.vevKK(statement, n);
                    }
                    statement.execute(this.config.getConnectionTestQuery());
                    return true;
                }
            }
            finally {
                this.NJSja(connection, this.dD);
                if (this.dN && !this.dL) {
                    connection.rollback();
                }
            }
        }
        catch (Exception exception) {
            this.dx.set(exception);
            this.dv.warn("{} - Failed to validate connection {} ({}). Possibly consider using a shorter maxLifetime value.", this.poolName, connection, exception.getMessage());
            return false;
        }
    }

    Exception kigNK() {
        return this.dx.get();
    }

    public DataSource getUnwrappedDataSource() {
        return this.bc;
    }

    PoolEntry njFGB() {
        return new PoolEntry(this.OlEE(), this, this.dK, this.dL);
    }

    void vevKK(Connection connection, ProxyConnection proxyConnection, int n) {
        int n2 = 0;
        if ((n & 1) != 0 && proxyConnection.UHsEs() != this.dK) {
            connection.setReadOnly(this.dK);
            n2 |= 1;
        }
        if ((n & 2) != 0 && proxyConnection.gqFj() != this.dL) {
            connection.setAutoCommit(this.dL);
            n2 |= 2;
        }
        if ((n & 4) != 0 && proxyConnection.zPttp() != this.dH) {
            connection.setTransactionIsolation(this.dH);
            n2 |= 4;
        }
        if ((n & 8) != 0 && this.aE != null && !this.aE.equals(proxyConnection.uznoQ())) {
            connection.setCatalog(this.aE);
            n2 |= 8;
        }
        if ((n & 0x10) != 0 && proxyConnection.QAYJ() != this.dD) {
            this.NJSja(connection, this.dD);
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0 && this.dJ != null && !this.dJ.equals(proxyConnection.pgVgq())) {
            connection.setSchema(this.dJ);
            n2 |= 0x20;
        }
        if (n2 != 0 && this.dv.isDebugEnabled()) {
            this.dv.debug("{} - Reset ({}) on connection {}", this.poolName, this.QwoMK(n2), connection);
        }
    }

    void cWoO() {
        if (this.dI instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.dI).shutdownNow();
        }
    }

    long tdgvl() {
        try {
            return this.bc != null ? (long)this.bc.getLoginTimeout() : TimeUnit.SECONDS.toSeconds(5L);
        }
        catch (SQLException sQLException) {
            return TimeUnit.SECONDS.toSeconds(5L);
        }
    }

    void vevKK(HikariPool hikariPool, boolean bl) {
        if (!this.config.isRegisterMbeans()) {
            return;
        }
        try {
            ObjectName objectName;
            ObjectName objectName2;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if ("true".equals(System.getProperty("hikaricp.jmx.register2.0"))) {
                objectName2 = new ObjectName("me.angeschossen.upgradeablespawners.hikari:type=PoolConfig,name=" + this.poolName);
                objectName = new ObjectName("me.angeschossen.upgradeablespawners.hikari:type=Pool,name=" + this.poolName);
            } else {
                objectName2 = new ObjectName("me.angeschossen.upgradeablespawners.hikari:type=PoolConfig (" + this.poolName + ")");
                objectName = new ObjectName("me.angeschossen.upgradeablespawners.hikari:type=Pool (" + this.poolName + ")");
            }
            if (bl) {
                if (!mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.registerMBean(this.config, objectName2);
                    mBeanServer.registerMBean(hikariPool, objectName);
                } else {
                    this.dv.error("{} - JMX name ({}) is already registered.", (Object)this.poolName, (Object)this.poolName);
                }
            } else if (mBeanServer.isRegistered(objectName2)) {
                mBeanServer.unregisterMBean(objectName2);
                mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            this.dv.warn("{} - Failed to {} management beans.", this.poolName, bl ? "register" : "unregister", exception);
        }
    }

    private void BYoXQ() {
        String string = this.config.getJdbcUrl();
        String string2 = this.config.getUsername();
        String string3 = this.config.getPassword();
        String string4 = this.config.getDataSourceClassName();
        String string5 = this.config.getDriverClassName();
        String string6 = this.config.getDataSourceJNDI();
        Properties properties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (string4 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string4, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (string != null && dataSource == null) {
            dataSource = new DriverDataSource(string, string5, properties, string2, string3);
        } else if (string6 != null && dataSource == null) {
            try {
                InitialContext initialContext = new InitialContext();
                dataSource = (DataSource)initialContext.lookup(string6);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            this.vevKK(dataSource);
            this.vevKK(dataSource, string4, string);
        }
        this.bc = dataSource;
    }

    private Connection OlEE() {
        long l = ClockSource.currentTime();
        Connection connection = null;
        try {
            String string = this.config.getUsername();
            String string2 = this.config.getPassword();
            Connection connection2 = connection = string == null ? this.bc.getConnection() : this.bc.getConnection(string, string2);
            if (connection == null) {
                throw new SQLTransientConnectionException("DataSource returned null unexpectedly");
            }
            this.NJSja(connection);
            this.dx.set(null);
            Connection connection3 = connection;
            return connection3;
        }
        catch (Exception exception) {
            if (connection != null) {
                this.NJSja(connection, "(Failed to create/setup connection)");
            } else if (this.kigNK() == null) {
                this.dv.debug("{} - Failed to create/setup connection: {}", (Object)this.poolName, (Object)exception.getMessage());
            }
            this.dx.set(exception);
            throw exception;
        }
        finally {
            if (this.dw != null) {
                this.dw.recordConnectionCreated(ClockSource.elapsedMillis(l));
            }
        }
    }

    private void NJSja(Connection connection) {
        try {
            if (this.dD == -1) {
                this.dD = this.vevKK(connection, this.aG);
            } else {
                this.NJSja(connection, this.aG);
            }
            if (connection.isReadOnly() != this.dK) {
                connection.setReadOnly(this.dK);
            }
            if (connection.getAutoCommit() != this.dL) {
                connection.setAutoCommit(this.dL);
            }
            this.OqjOn(connection);
            if (this.dH != this.dG) {
                connection.setTransactionIsolation(this.dH);
            }
            if (this.aE != null) {
                connection.setCatalog(this.aE);
            }
            if (this.dJ != null) {
                connection.setSchema(this.dJ);
            }
            this.vevKK(connection, this.config.getConnectionInitSql(), true);
            this.NJSja(connection, this.dD);
        }
        catch (SQLException sQLException) {
            throw new ConnectionSetupException(sQLException);
        }
    }

    private void OqjOn(Connection connection) {
        if (!this.dO) {
            this.QmAmI(connection);
            this.cxrwk(connection);
            this.dO = true;
        }
    }

    private void QmAmI(Connection connection) {
        try {
            if (this.dM) {
                connection.isValid(1);
            } else {
                this.vevKK(connection, this.config.getConnectionTestQuery(), false);
            }
        }
        catch (AbstractMethodError | Exception throwable) {
            this.dv.error("{} - Failed to execute{} connection test query ({}).", this.poolName, this.dM ? " isValid() for connection, configure" : "", throwable.getMessage());
            throw throwable;
        }
    }

    private void cxrwk(Connection connection) {
        block3: {
            try {
                this.dG = connection.getTransactionIsolation();
                if (this.dH == -1) {
                    this.dH = this.dG;
                }
            }
            catch (SQLException sQLException) {
                this.dv.warn("{} - Default transaction isolation level detection failed ({}).", (Object)this.poolName, (Object)sQLException.getMessage());
                if (sQLException.getSQLState() == null || sQLException.getSQLState().startsWith("08")) break block3;
                throw sQLException;
            }
        }
    }

    private void vevKK(Statement statement, int n) {
        block3: {
            if (this.dF != 0) {
                try {
                    statement.setQueryTimeout(n);
                    this.dF = 1;
                }
                catch (Exception exception) {
                    if (this.dF != -1) break block3;
                    this.dF = 0;
                    this.dv.info("{} - Failed to set query timeout for statement. ({})", (Object)this.poolName, (Object)exception.getMessage());
                }
            }
        }
    }

    private int vevKK(Connection connection, long l) {
        block4: {
            if (this.dE != 0) {
                try {
                    int n = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.dI, (int)l);
                    this.dE = 1;
                    return n;
                }
                catch (AbstractMethodError | Exception throwable) {
                    if (this.dE != -1) break block4;
                    this.dE = 0;
                    this.dv.info("{} - Driver does not support get/set network timeout for connections. ({})", (Object)this.poolName, (Object)throwable.getMessage());
                    if (this.aG < TimeUnit.SECONDS.toMillis(1L)) {
                        this.dv.warn("{} - A validationTimeout of less than 1 second cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                    }
                    if (this.aG % TimeUnit.SECONDS.toMillis(1L) == 0L) break block4;
                    this.dv.warn("{} - A validationTimeout with fractional second granularity cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                }
            }
        }
        return 0;
    }

    private void NJSja(Connection connection, long l) {
        if (this.dE == 1) {
            connection.setNetworkTimeout(this.dI, (int)l);
        }
    }

    private void vevKK(Connection connection, String string, boolean bl) {
        if (string != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
            }
            if (this.dN && !this.dL) {
                if (bl) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
            }
        }
    }

    private void vevKK(DataSource dataSource, String string, String string2) {
        if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.dI = new SynchronousExecutor();
        } else {
            ThreadFactory threadFactory = this.config.getThreadFactory();
            threadFactory = threadFactory != null ? threadFactory : new UtilityElf.DefaultThreadFactory(this.poolName + " network timeout executor", true);
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
            threadPoolExecutor.setKeepAliveTime(15L, TimeUnit.SECONDS);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.dI = threadPoolExecutor;
        }
    }

    private void vevKK(DataSource dataSource) {
        if (this.aF != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout(Math.max(1, (int)TimeUnit.MILLISECONDS.toSeconds(500L + this.aF)));
            }
            catch (Exception exception) {
                this.dv.info("{} - Failed to set login timeout for data source. ({})", (Object)this.poolName, (Object)exception.getMessage());
            }
        }
    }

    private String QwoMK(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dz.length; ++i) {
            if ((n & 1 << i) == 0) continue;
            stringBuilder.append(dz[i]).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    static final class NopMetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }
    }

    static class MetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        final IMetricsTracker dQ;

        MetricsTrackerDelegate(IMetricsTracker iMetricsTracker) {
            this.dQ = iMetricsTracker;
        }

        @Override
        public void recordConnectionUsage(PoolEntry poolEntry) {
            this.dQ.recordConnectionUsageMillis(poolEntry.prGd());
        }

        @Override
        public void recordConnectionCreated(long l) {
            this.dQ.recordConnectionCreatedMillis(l);
        }

        @Override
        public void recordBorrowTimeoutStats(long l) {
            this.dQ.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l));
        }

        @Override
        public void recordBorrowStats(PoolEntry poolEntry, long l) {
            long l2;
            poolEntry.dV = l2 = ClockSource.currentTime();
            this.dQ.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l, l2));
        }

        @Override
        public void recordConnectionTimeout() {
            this.dQ.recordConnectionTimeout();
        }

        @Override
        public void close() {
            this.dQ.close();
        }
    }

    static interface IMetricsTrackerDelegate
    extends AutoCloseable {
        default public void recordConnectionUsage(PoolEntry poolEntry) {
        }

        default public void recordConnectionCreated(long connectionCreatedMillis) {
        }

        default public void recordBorrowTimeoutStats(long startTime) {
        }

        default public void recordBorrowStats(PoolEntry poolEntry, long startTime) {
        }

        default public void recordConnectionTimeout() {
        }

        @Override
        default public void close() {
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(PoolBase.class).debug("Failed to execute: {}", (Object)runnable, (Object)exception);
            }
        }
    }

    static class ConnectionSetupException
    extends Exception {
        private static final long dP = 929872118275916521L;

        ConnectionSetupException(Throwable throwable) {
            super(throwable);
        }
    }
}

