/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablespawners.hikari.HikariConfig;
import me.angeschossen.upgradeablespawners.hikari.HikariPoolMXBean;
import me.angeschossen.upgradeablespawners.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.upgradeablespawners.hikari.metrics.PoolStats;
import me.angeschossen.upgradeablespawners.hikari.metrics.dropwizard.CodahaleHealthChecker;
import me.angeschossen.upgradeablespawners.hikari.metrics.dropwizard.CodahaleMetricsTrackerFactory;
import me.angeschossen.upgradeablespawners.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import me.angeschossen.upgradeablespawners.hikari.pool.PoolBase;
import me.angeschossen.upgradeablespawners.hikari.pool.PoolEntry;
import me.angeschossen.upgradeablespawners.hikari.pool.ProxyConnection;
import me.angeschossen.upgradeablespawners.hikari.pool.ProxyLeakTaskFactory;
import me.angeschossen.upgradeablespawners.hikari.util.ClockSource;
import me.angeschossen.upgradeablespawners.hikari.util.ConcurrentBag;
import me.angeschossen.upgradeablespawners.hikari.util.SuspendResumeLock;
import me.angeschossen.upgradeablespawners.hikari.util.UtilityElf;
import me.angeschossen.upgradeablespawners.slf4j.Logger;
import me.angeschossen.upgradeablespawners.slf4j.LoggerFactory;

public final class HikariPool
extends PoolBase
implements HikariPoolMXBean,
ConcurrentBag.IBagStateListener {
    private final Logger cW = LoggerFactory.getLogger(HikariPool.class);
    public static final int POOL_NORMAL = 0;
    public static final int POOL_SUSPENDED = 1;
    public static final int POOL_SHUTDOWN = 2;
    public volatile int poolState;
    private final long cX = Long.getLong("me.angeschossen.upgradeablespawners.hikari.aliveBypassWindowMs", TimeUnit.MILLISECONDS.toMillis(500L));
    private final long cY = Long.getLong("me.angeschossen.upgradeablespawners.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
    private static final String cZ = "(connection was evicted)";
    private static final String da = "(connection is dead)";
    private final PoolEntryCreator db = new PoolEntryCreator(null);
    private final PoolEntryCreator dc = new PoolEntryCreator("After adding ");
    private final Collection<Runnable> dd;
    private final ThreadPoolExecutor de;
    private final ThreadPoolExecutor df;
    private final ConcurrentBag<PoolEntry> dg = new ConcurrentBag(this);
    private final ProxyLeakTaskFactory dh;
    private final SuspendResumeLock di;
    private final ScheduledExecutorService dj;
    private ScheduledFuture<?> dk;

    public HikariPool(HikariConfig hikariConfig) {
        super(hikariConfig);
        this.di = hikariConfig.isAllowPoolSuspension() ? new SuspendResumeLock() : SuspendResumeLock.FAUX_LOCK;
        this.dj = this.TQTKr();
        this.uOhXr();
        if (hikariConfig.getMetricsTrackerFactory() != null) {
            this.setMetricsTrackerFactory(hikariConfig.getMetricsTrackerFactory());
        } else {
            this.setMetricRegistry(hikariConfig.getMetricRegistry());
        }
        this.setHealthCheckRegistry(hikariConfig.getHealthCheckRegistry());
        this.vevKK(this, true);
        ThreadFactory threadFactory = hikariConfig.getThreadFactory();
        int n = hikariConfig.getMaximumPoolSize();
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(n);
        this.dd = Collections.unmodifiableCollection(linkedBlockingQueue);
        this.de = UtilityElf.createThreadPoolExecutor(linkedBlockingQueue, this.poolName + " connection adder", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        this.df = UtilityElf.createThreadPoolExecutor(n, this.poolName + " connection closer", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.dh = new ProxyLeakTaskFactory(hikariConfig.getLeakDetectionThreshold(), this.dj);
        this.dk = this.dj.scheduleWithFixedDelay(new HouseKeeper(), 100L, this.cY, TimeUnit.MILLISECONDS);
        if (Boolean.getBoolean("me.angeschossen.upgradeablespawners.hikari.blockUntilFilled") && hikariConfig.getInitializationFailTimeout() > 1L) {
            this.de.setMaximumPoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            this.de.setCorePoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            long l = ClockSource.currentTime();
            while (ClockSource.elapsedMillis(l) < hikariConfig.getInitializationFailTimeout() && this.getTotalConnections() < hikariConfig.getMinimumIdle()) {
                UtilityElf.quietlySleep(TimeUnit.MILLISECONDS.toMillis(100L));
            }
            this.de.setCorePoolSize(1);
            this.de.setMaximumPoolSize(1);
        }
    }

    public Connection getConnection() {
        return this.getConnection(this.aF);
    }

    /*
     * Exception decompiling
     */
    public Connection getConnection(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        block8: {
            this.poolState = 2;
            if (this.de != null) break block8;
            this.KybNX("After shutdown ");
            this.vevKK(this, false);
            this.dw.close();
            return;
        }
        try {
            this.KybNX("Before shutdown ");
            if (this.dk != null) {
                this.dk.cancel(false);
                this.dk = null;
            }
            this.softEvictConnections();
            this.de.shutdown();
            this.de.awaitTermination(this.tdgvl(), TimeUnit.SECONDS);
            this.ovnIW();
            this.dg.close();
            ThreadPoolExecutor threadPoolExecutor = UtilityElf.createThreadPoolExecutor(this.config.getMaximumPoolSize(), this.poolName + " connection assassinator", this.config.getThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                long l = ClockSource.currentTime();
                do {
                    this.vevKK(threadPoolExecutor);
                    this.softEvictConnections();
                } while (this.getTotalConnections() > 0 && ClockSource.elapsedMillis(l) < TimeUnit.SECONDS.toMillis(10L));
            }
            finally {
                threadPoolExecutor.shutdown();
                threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            this.cWoO();
            this.df.shutdown();
            this.df.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            this.KybNX("After shutdown ");
            this.vevKK(this, false);
            this.dw.close();
            throw throwable;
        }
        this.KybNX("After shutdown ");
        this.vevKK(this, false);
        this.dw.close();
    }

    public void evictConnection(Connection connection) {
        ProxyConnection proxyConnection = (ProxyConnection)connection;
        proxyConnection.frHgG();
        try {
            this.vevKK(proxyConnection.gcVPw(), "(connection evicted by user)", !connection.isClosed());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setMetricRegistry(Object object) {
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "com.codahale.metrics.MetricRegistry")) {
            this.setMetricsTrackerFactory(new CodahaleMetricsTrackerFactory((MetricRegistry)object));
        } else if (object != null && UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            this.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory((MeterRegistry)object));
        } else {
            this.setMetricsTrackerFactory(null);
        }
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        this.dw = metricsTrackerFactory != null ? new PoolBase.MetricsTrackerDelegate(metricsTrackerFactory.create(this.config.getPoolName(), this.jJIRI())) : new PoolBase.NopMetricsTrackerDelegate();
    }

    public void setHealthCheckRegistry(Object object) {
        if (object != null) {
            CodahaleHealthChecker.registerHealthChecks(this, this.config, (HealthCheckRegistry)object);
        }
    }

    @Override
    public void addBagItem(int n) {
        boolean bl;
        boolean bl2 = bl = n - this.dd.size() >= 0;
        if (bl) {
            this.de.submit(this.db);
        } else {
            this.cW.debug("{} - Add connection elided, waiting {}, queue {}", this.poolName, n, this.dd.size());
        }
    }

    @Override
    public int getActiveConnections() {
        return this.dg.getCount(1);
    }

    @Override
    public int getIdleConnections() {
        return this.dg.getCount(0);
    }

    @Override
    public int getTotalConnections() {
        return this.dg.size();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.dg.getWaitingThreadCount();
    }

    @Override
    public void softEvictConnections() {
        this.dg.values().forEach(poolEntry -> this.vevKK((PoolEntry)poolEntry, "(connection evicted)", false));
    }

    @Override
    public synchronized void suspendPool() {
        if (this.di == SuspendResumeLock.FAUX_LOCK) {
            throw new IllegalStateException(this.poolName + " - is not suspendable");
        }
        if (this.poolState != 1) {
            this.di.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public synchronized void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.iqvHr();
            this.di.resume();
        }
    }

    void KybNX(String ... stringArray) {
        if (this.cW.isDebugEnabled()) {
            this.cW.debug("{} - {}stats (total={}, active={}, idle={}, waiting={})", this.poolName, stringArray.length > 0 ? stringArray[0] : "", this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection());
        }
    }

    @Override
    void vevKK(PoolEntry poolEntry) {
        this.dw.recordConnectionUsage(poolEntry);
        this.dg.requite(poolEntry);
    }

    void vevKK(PoolEntry poolEntry, String string) {
        if (this.dg.remove(poolEntry)) {
            Connection connection = poolEntry.VRoHa();
            this.df.execute(() -> {
                this.NJSja(connection, string);
                if (this.poolState == 0) {
                    this.iqvHr();
                }
            });
        }
    }

    int[] RlDAf() {
        return this.dg.getStateCounts();
    }

    private PoolEntry syTDr() {
        block6: {
            try {
                long l;
                long l2;
                PoolEntry poolEntry = this.njFGB();
                long l3 = this.config.getMaxLifetime();
                if (l3 > 0L) {
                    l2 = l3 > 10000L ? ThreadLocalRandom.current().nextLong(l3 / 40L) : 0L;
                    l = l3 - l2;
                    poolEntry.vevKK(this.dj.schedule(new MaxLifetimeTask(poolEntry), l, TimeUnit.MILLISECONDS));
                }
                if ((l2 = this.config.getKeepaliveTime()) > 0L) {
                    l = ThreadLocalRandom.current().nextLong(l2 / 10L);
                    long l4 = l2 - l;
                    poolEntry.setKeepalive(this.dj.scheduleWithFixedDelay(new KeepaliveTask(poolEntry), l4, l4, TimeUnit.MILLISECONDS));
                }
                return poolEntry;
            }
            catch (PoolBase.ConnectionSetupException connectionSetupException) {
                if (this.poolState == 0) {
                    this.cW.error("{} - Error thrown while acquiring connection from data source", (Object)this.poolName, (Object)connectionSetupException.getCause());
                    this.dx.set(connectionSetupException);
                }
            }
            catch (Exception exception) {
                if (this.poolState != 0) break block6;
                this.cW.debug("{} - Cannot acquire connection from data source", (Object)this.poolName, (Object)exception);
            }
        }
        return null;
    }

    private synchronized void iqvHr() {
        int n = Math.min(this.config.getMaximumPoolSize() - this.getTotalConnections(), this.config.getMinimumIdle() - this.getIdleConnections()) - this.dd.size();
        if (n <= 0) {
            this.cW.debug("{} - Fill pool skipped, pool is at sufficient level.", (Object)this.poolName);
        }
        for (int i = 0; i < n; ++i) {
            this.de.submit(i < n - 1 ? this.db : this.dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vevKK(ExecutorService executorService) {
        for (PoolEntry poolEntry : this.dg.values(1)) {
            Connection connection = poolEntry.VRoHa();
            try {
                connection.abort(executorService);
            }
            catch (Throwable throwable) {
                this.NJSja(connection, "(connection aborted during shutdown)");
            }
            finally {
                this.dg.remove(poolEntry);
            }
        }
    }

    private void uOhXr() {
        long l = this.config.getInitializationFailTimeout();
        if (l < 0L) {
            return;
        }
        long l2 = ClockSource.currentTime();
        do {
            PoolEntry poolEntry;
            if ((poolEntry = this.syTDr()) != null) {
                if (this.config.getMinimumIdle() > 0) {
                    this.dg.add(poolEntry);
                    this.cW.debug("{} - Added connection {}", (Object)this.poolName, (Object)poolEntry.dT);
                } else {
                    this.NJSja(poolEntry.VRoHa(), "(initialization check complete and minimumIdle is zero)");
                }
                return;
            }
            if (this.kigNK() instanceof PoolBase.ConnectionSetupException) {
                this.ZLamF(this.kigNK().getCause());
            }
            UtilityElf.quietlySleep(TimeUnit.SECONDS.toMillis(1L));
        } while (ClockSource.elapsedMillis(l2) < l);
        if (l > 0L) {
            this.ZLamF(this.kigNK());
        }
    }

    private void ZLamF(Throwable throwable) {
        this.cW.error("{} - Exception during pool initialization.", (Object)this.poolName, (Object)throwable);
        this.ovnIW();
        throw new PoolInitializationException(throwable);
    }

    private boolean vevKK(PoolEntry poolEntry, String string, boolean bl) {
        poolEntry.jvrMH();
        if (bl || this.dg.reserve(poolEntry)) {
            this.vevKK(poolEntry, string);
            return true;
        }
        return false;
    }

    private ScheduledExecutorService TQTKr() {
        if (this.config.getScheduledExecutor() == null) {
            ThreadFactory threadFactory = Optional.ofNullable(this.config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(this.poolName + " housekeeper", true));
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
            scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            return scheduledThreadPoolExecutor;
        }
        return this.config.getScheduledExecutor();
    }

    private void ovnIW() {
        if (this.config.getScheduledExecutor() == null) {
            this.dj.shutdownNow();
        }
    }

    private PoolStats jJIRI() {
        return new PoolStats(TimeUnit.SECONDS.toMillis(1L)){

            @Override
            protected void update() {
                this.pendingThreads = HikariPool.this.getThreadsAwaitingConnection();
                this.idleConnections = HikariPool.this.getIdleConnections();
                this.totalConnections = HikariPool.this.getTotalConnections();
                this.activeConnections = HikariPool.this.getActiveConnections();
                this.maxConnections = HikariPool.this.config.getMaximumPoolSize();
                this.minConnections = HikariPool.this.config.getMinimumIdle();
            }
        };
    }

    private SQLException CjTHM(long l) {
        this.KybNX("Timeout failure ");
        this.dw.recordConnectionTimeout();
        String string = null;
        Exception exception = this.kigNK();
        if (exception instanceof SQLException) {
            string = ((SQLException)exception).getSQLState();
        }
        SQLTransientConnectionException sQLTransientConnectionException = new SQLTransientConnectionException(this.poolName + " - Connection is not available, request timed out after " + ClockSource.elapsedMillis(l) + "ms.", string, exception);
        if (exception instanceof SQLException) {
            sQLTransientConnectionException.setNextException((SQLException)exception);
        }
        return sQLTransientConnectionException;
    }

    public static class PoolInitializationException
    extends RuntimeException {
        private static final long du = 929872118275916520L;

        public PoolInitializationException(Throwable throwable) {
            super("Failed to initialize pool: " + throwable.getMessage(), throwable);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class KeepaliveTask
    implements Runnable {
        private final PoolEntry do;

        KeepaliveTask(PoolEntry poolEntry) {
            this.do = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.dg.reserve(this.do)) {
                if (!HikariPool.this.vevKK(this.do.dT)) {
                    HikariPool.this.vevKK(this.do, HikariPool.da, true);
                    HikariPool.this.addBagItem(HikariPool.this.dg.getWaitingThreadCount());
                } else {
                    HikariPool.this.dg.unreserve(this.do);
                    HikariPool.this.cW.debug("{} - keepalive: connection {} is alive", (Object)HikariPool.this.poolName, (Object)this.do.dT);
                }
            }
        }
    }

    private final class MaxLifetimeTask
    implements Runnable {
        private final PoolEntry dq;

        MaxLifetimeTask(PoolEntry poolEntry) {
            this.dq = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.vevKK(this.dq, "(connection has passed maxLifetime)", false)) {
                HikariPool.this.addBagItem(HikariPool.this.dg.getWaitingThreadCount());
            }
        }
    }

    private final class HouseKeeper
    implements Runnable {
        private volatile long dm;

        private HouseKeeper() {
            this.dm = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.this.cY);
        }

        @Override
        public void run() {
            try {
                HikariPool.this.aF = HikariPool.this.config.getConnectionTimeout();
                HikariPool.this.aG = HikariPool.this.config.getValidationTimeout();
                HikariPool.this.dh.hyNIL(HikariPool.this.config.getLeakDetectionThreshold());
                HikariPool.this.aE = HikariPool.this.config.getCatalog() != null && !HikariPool.this.config.getCatalog().equals(HikariPool.this.aE) ? HikariPool.this.config.getCatalog() : HikariPool.this.aE;
                long l = HikariPool.this.config.getIdleTimeout();
                long l2 = ClockSource.currentTime();
                if (ClockSource.plusMillis(l2, 128L) < ClockSource.plusMillis(this.dm, HikariPool.this.cY)) {
                    HikariPool.this.cW.warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.dm, l2));
                    this.dm = l2;
                    HikariPool.this.softEvictConnections();
                    return;
                }
                if (l2 > ClockSource.plusMillis(this.dm, 3L * HikariPool.this.cY / 2L)) {
                    HikariPool.this.cW.warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.dm, l2));
                }
                this.dm = l2;
                String string = "Pool ";
                if (l > 0L && HikariPool.this.config.getMinimumIdle() < HikariPool.this.config.getMaximumPoolSize()) {
                    HikariPool.this.KybNX("Before cleanup ");
                    string = "After cleanup  ";
                    List list = HikariPool.this.dg.values(0);
                    int n = list.size() - HikariPool.this.config.getMinimumIdle();
                    for (PoolEntry poolEntry : list) {
                        if (n <= 0 || ClockSource.elapsedMillis(poolEntry.dU, l2) <= l || !HikariPool.this.dg.reserve(poolEntry)) continue;
                        HikariPool.this.vevKK(poolEntry, "(connection has passed idleTimeout)");
                        --n;
                    }
                }
                HikariPool.this.KybNX(string);
                HikariPool.this.iqvHr();
            }
            catch (Exception exception) {
                HikariPool.this.cW.error("Unexpected exception in housekeeping task", exception);
            }
        }
    }

    private final class PoolEntryCreator
    implements Callable<Boolean> {
        private final String ds;

        PoolEntryCreator(String string) {
            this.ds = string;
        }

        @Override
        public Boolean call() {
            long l = 250L;
            while (HikariPool.this.poolState == 0 && this.fhlDZ()) {
                PoolEntry poolEntry = HikariPool.this.syTDr();
                if (poolEntry != null) {
                    HikariPool.this.dg.add(poolEntry);
                    HikariPool.this.cW.debug("{} - Added connection {}", (Object)HikariPool.this.poolName, (Object)poolEntry.dT);
                    if (this.ds != null) {
                        HikariPool.this.KybNX(this.ds);
                    }
                    return Boolean.TRUE;
                }
                if (this.ds != null) {
                    HikariPool.this.cW.debug("{} - Connection add failed, sleeping with backoff: {}ms", (Object)HikariPool.this.poolName, (Object)l);
                }
                UtilityElf.quietlySleep(l);
                l = Math.min(TimeUnit.SECONDS.toMillis(10L), Math.min(HikariPool.this.aF, (long)((double)l * 1.5)));
            }
            return Boolean.FALSE;
        }

        private synchronized boolean fhlDZ() {
            return HikariPool.this.getTotalConnections() < HikariPool.this.config.getMaximumPoolSize() && (HikariPool.this.dg.getWaitingThreadCount() > 0 || HikariPool.this.getIdleConnections() < HikariPool.this.config.getMinimumIdle());
        }
    }
}

