/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablespawners.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablespawners.hikari.metrics.prometheus.HikariCPCollector;
import me.angeschossen.upgradeablespawners.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

class PrometheusMetricsTracker
implements IMetricsTracker {
    private static final Counter cH = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private static final Summary cI = PrometheusMetricsTracker.fidLB("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)");
    private static final Summary cJ = PrometheusMetricsTracker.fidLB("hikaricp_connection_usage_millis", "Connection usage (ms)");
    private static final Summary cK = PrometheusMetricsTracker.fidLB("hikaricp_connection_creation_millis", "Connection creation (ms)");
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> cL = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final String cM;
    private final HikariCPCollector cN;
    private final Counter.Child cO;
    private final Summary.Child cP;
    private final Summary.Child cQ;
    private final Summary.Child cR;

    PrometheusMetricsTracker(String string, CollectorRegistry collectorRegistry, HikariCPCollector hikariCPCollector) {
        this.vevKK(collectorRegistry);
        this.cM = string;
        this.cN = hikariCPCollector;
        this.cO = (Counter.Child)cH.labels(new String[]{string});
        this.cP = (Summary.Child)cI.labels(new String[]{string});
        this.cQ = (Summary.Child)cJ.labels(new String[]{string});
        this.cR = (Summary.Child)cK.labels(new String[]{string});
    }

    private void vevKK(CollectorRegistry collectorRegistry) {
        if (cL.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            cH.register(collectorRegistry);
            cI.register(collectorRegistry);
            cJ.register(collectorRegistry);
            cK.register(collectorRegistry);
        }
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.cP.observe((double)l);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.cQ.observe((double)l);
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.cR.observe((double)l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.cO.inc();
    }

    private static Summary fidLB(String string, String string2) {
        return ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(string)).labelNames(new String[]{"pool"})).help(string2)).quantile(0.5, 0.05).quantile(0.95, 0.01).quantile(0.99, 0.001).maxAgeSeconds(TimeUnit.MINUTES.toSeconds(5L)).ageBuckets(5).create();
    }

    @Override
    public void close() {
        this.cN.remove(this.cM);
        cH.remove(new String[]{this.cM});
        cI.remove(new String[]{this.cM});
        cJ.remove(new String[]{this.cM});
        cK.remove(new String[]{this.cM});
    }
}

