/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.angeschossen.upgradeablespawners.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablespawners.hikari.metrics.prometheus.HikariCPCollector;
import me.angeschossen.upgradeablespawners.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

class PrometheusHistogramMetricsTracker
implements IMetricsTracker {
    private static final Counter ct = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private static final Histogram cu = PrometheusHistogramMetricsTracker.vevKK("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)", 1000.0);
    private static final Histogram cv = PrometheusHistogramMetricsTracker.vevKK("hikaricp_connection_usage_millis", "Connection usage (ms)", 1.0);
    private static final Histogram cw = PrometheusHistogramMetricsTracker.vevKK("hikaricp_connection_creation_millis", "Connection creation (ms)", 1.0);
    private final Counter.Child cx;
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> cy = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final String cz;
    private final HikariCPCollector cA;
    private final Histogram.Child cB;
    private final Histogram.Child cC;
    private final Histogram.Child cD;

    private static Histogram vevKK(String string, String string2, double d) {
        return ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(string)).labelNames(new String[]{"pool"})).help(string2)).exponentialBuckets(d, 2.0, 11).create();
    }

    PrometheusHistogramMetricsTracker(String string, CollectorRegistry collectorRegistry, HikariCPCollector hikariCPCollector) {
        this.vevKK(collectorRegistry);
        this.cz = string;
        this.cA = hikariCPCollector;
        this.cx = (Counter.Child)ct.labels(new String[]{string});
        this.cB = (Histogram.Child)cu.labels(new String[]{string});
        this.cC = (Histogram.Child)cv.labels(new String[]{string});
        this.cD = (Histogram.Child)cw.labels(new String[]{string});
    }

    private void vevKK(CollectorRegistry collectorRegistry) {
        if (cy.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            ct.register(collectorRegistry);
            cu.register(collectorRegistry);
            cv.register(collectorRegistry);
            cw.register(collectorRegistry);
        }
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.cB.observe((double)l);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.cC.observe((double)l);
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.cD.observe((double)l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.cx.inc();
    }

    @Override
    public void close() {
        this.cA.remove(this.cz);
        ct.remove(new String[]{this.cz});
        cu.remove(new String[]{this.cz});
        cv.remove(new String[]{this.cz});
        cw.remove(new String[]{this.cz});
    }
}

