/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.angeschossen.upgradeablespawners.hikari.metrics.PoolStats;

class HikariCPCollector
extends Collector {
    private static final List<String> cr = Collections.singletonList("pool");
    private final Map<String, PoolStats> cs = new ConcurrentHashMap<String, PoolStats>();

    HikariCPCollector() {
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(this.vevKK("hikaricp_active_connections", "Active connections", PoolStats::getActiveConnections), this.vevKK("hikaricp_idle_connections", "Idle connections", PoolStats::getIdleConnections), this.vevKK("hikaricp_pending_threads", "Pending threads", PoolStats::getPendingThreads), this.vevKK("hikaricp_connections", "The number of current connections", PoolStats::getTotalConnections), this.vevKK("hikaricp_max_connections", "Max connections", PoolStats::getMaxConnections), this.vevKK("hikaricp_min_connections", "Min connections", PoolStats::getMinConnections));
    }

    void vevKK(String string, PoolStats poolStats) {
        this.cs.put(string, poolStats);
    }

    void remove(String string) {
        this.cs.remove(string);
    }

    private GaugeMetricFamily vevKK(String string2, String string3, Function<PoolStats, Integer> function) {
        GaugeMetricFamily gaugeMetricFamily = new GaugeMetricFamily(string2, string3, cr);
        this.cs.forEach((string, poolStats) -> gaugeMetricFamily.addMetric(Collections.singletonList(string), (double)((Integer)function.apply((PoolStats)poolStats)).intValue()));
        return gaugeMetricFamily;
    }
}

