/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablespawners.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablespawners.hikari.metrics.PoolStats;

public class MicrometerMetricsTracker
implements IMetricsTracker {
    public static final String HIKARI_METRIC_NAME_PREFIX = "hikaricp";
    private static final String bT = "pool";
    private static final String bU = "hikaricp.connections.acquire";
    private static final String bV = "hikaricp.connections.usage";
    private static final String bW = "hikaricp.connections.creation";
    private static final String bX = "hikaricp.connections.timeout";
    private static final String bY = "hikaricp.connections";
    private static final String bZ = "hikaricp.connections.idle";
    private static final String ca = "hikaricp.connections.active";
    private static final String cb = "hikaricp.connections.pending";
    private static final String cc = "hikaricp.connections.max";
    private static final String cd = "hikaricp.connections.min";
    private final Timer ce;
    private final Counter cf;
    private final Timer cg;
    private final Timer ch;
    private final Gauge ci;
    private final Gauge cj;
    private final Gauge ck;
    private final Gauge cl;
    private final Gauge cm;
    private final Gauge cn;
    private final MeterRegistry co;
    private final PoolStats cp;

    MicrometerMetricsTracker(String string, PoolStats poolStats, MeterRegistry meterRegistry) {
        this.cp = poolStats;
        this.co = meterRegistry;
        this.ce = Timer.builder((String)bU).description("Connection acquire time").tags(new String[]{bT, string}).register(meterRegistry);
        this.ch = Timer.builder((String)bW).description("Connection creation time").tags(new String[]{bT, string}).register(meterRegistry);
        this.cg = Timer.builder((String)bV).description("Connection usage time").tags(new String[]{bT, string}).register(meterRegistry);
        this.cf = Counter.builder((String)bX).description("Connection timeout total count").tags(new String[]{bT, string}).register(meterRegistry);
        this.ci = Gauge.builder((String)bY, (Object)poolStats, PoolStats::getTotalConnections).description("Total connections").tags(new String[]{bT, string}).register(meterRegistry);
        this.cj = Gauge.builder((String)bZ, (Object)poolStats, PoolStats::getIdleConnections).description("Idle connections").tags(new String[]{bT, string}).register(meterRegistry);
        this.ck = Gauge.builder((String)ca, (Object)poolStats, PoolStats::getActiveConnections).description("Active connections").tags(new String[]{bT, string}).register(meterRegistry);
        this.cl = Gauge.builder((String)cb, (Object)poolStats, PoolStats::getPendingThreads).description("Pending threads").tags(new String[]{bT, string}).register(meterRegistry);
        this.cm = Gauge.builder((String)cc, (Object)poolStats, PoolStats::getMaxConnections).description("Max connections").tags(new String[]{bT, string}).register(meterRegistry);
        this.cn = Gauge.builder((String)cd, (Object)poolStats, PoolStats::getMinConnections).description("Min connections").tags(new String[]{bT, string}).register(meterRegistry);
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.ce.record(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.cg.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordConnectionTimeout() {
        this.cf.increment();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.ch.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.co.remove((Meter)this.ce);
        this.co.remove((Meter)this.cf);
        this.co.remove((Meter)this.cg);
        this.co.remove((Meter)this.ch);
        this.co.remove((Meter)this.ci);
        this.co.remove((Meter)this.cj);
        this.co.remove((Meter)this.ck);
        this.co.remove((Meter)this.cl);
        this.co.remove((Meter)this.cm);
        this.co.remove((Meter)this.cn);
    }
}

