/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablespawners.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablespawners.hikari.metrics.PoolStats;

public final class CodaHaleMetricsTracker
implements IMetricsTracker {
    private final String bx;
    private final Timer by;
    private final Histogram bz;
    private final Histogram bA;
    private final Meter bB;
    private final MetricRegistry bC;
    private static final String bD = "pool";
    private static final String bE = "Wait";
    private static final String bF = "Usage";
    private static final String bG = "ConnectionCreation";
    private static final String bH = "ConnectionTimeoutRate";
    private static final String bI = "TotalConnections";
    private static final String bJ = "IdleConnections";
    private static final String bK = "ActiveConnections";
    private static final String bL = "PendingConnections";
    private static final String bM = "MaxConnections";
    private static final String bN = "MinConnections";

    CodaHaleMetricsTracker(String string, PoolStats poolStats, MetricRegistry metricRegistry) {
        this.bx = string;
        this.bC = metricRegistry;
        this.by = metricRegistry.timer(MetricRegistry.name((String)string, (String[])new String[]{bD, bE}));
        this.bz = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{bD, bF}));
        this.bA = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{bD, bG}));
        this.bB = metricRegistry.meter(MetricRegistry.name((String)string, (String[])new String[]{bD, bH}));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{bD, bI}), (Metric)((Gauge)poolStats::getTotalConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{bD, bJ}), (Metric)((Gauge)poolStats::getIdleConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{bD, bK}), (Metric)((Gauge)poolStats::getActiveConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{bD, bL}), (Metric)((Gauge)poolStats::getPendingThreads));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{bD, bM}), (Metric)((Gauge)poolStats::getMaxConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{bD, bN}), (Metric)((Gauge)poolStats::getMinConnections));
    }

    @Override
    public void close() {
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bE}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bF}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bG}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bH}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bI}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bJ}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bK}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bL}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bM}));
        this.bC.remove(MetricRegistry.name((String)this.bx, (String[])new String[]{bD, bN}));
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.by.update(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.bz.update(l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.bB.mark();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.bA.update(l);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.by;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.bz;
    }

    public Histogram getConnectionCreationHistogram() {
        return this.bA;
    }
}

