/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari.metrics;

import java.util.concurrent.atomic.AtomicLong;
import me.angeschossen.upgradeablespawners.hikari.util.ClockSource;

public abstract class PoolStats {
    private final AtomicLong bv;
    private final long bw;
    protected volatile int totalConnections;
    protected volatile int idleConnections;
    protected volatile int activeConnections;
    protected volatile int pendingThreads;
    protected volatile int maxConnections;
    protected volatile int minConnections;

    public PoolStats(long l) {
        this.bw = l;
        this.bv = new AtomicLong();
    }

    public int getTotalConnections() {
        if (this.FcmSF()) {
            this.update();
        }
        return this.totalConnections;
    }

    public int getIdleConnections() {
        if (this.FcmSF()) {
            this.update();
        }
        return this.idleConnections;
    }

    public int getActiveConnections() {
        if (this.FcmSF()) {
            this.update();
        }
        return this.activeConnections;
    }

    public int getPendingThreads() {
        if (this.FcmSF()) {
            this.update();
        }
        return this.pendingThreads;
    }

    public int getMaxConnections() {
        if (this.FcmSF()) {
            this.update();
        }
        return this.maxConnections;
    }

    public int getMinConnections() {
        if (this.FcmSF()) {
            this.update();
        }
        return this.minConnections;
    }

    protected abstract void update();

    private boolean FcmSF() {
        long l;
        long l2;
        do {
            l = ClockSource.currentTime();
            l2 = this.bv.get();
            if (l2 <= l) continue;
            return false;
        } while (!this.bv.compareAndSet(l2, ClockSource.plusMillis(l, this.bw)));
        return true;
    }
}

