/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.sql.DataSource;
import me.angeschossen.upgradeablespawners.hikari.HikariConfig;
import me.angeschossen.upgradeablespawners.hikari.HikariConfigMXBean;
import me.angeschossen.upgradeablespawners.hikari.HikariPoolMXBean;
import me.angeschossen.upgradeablespawners.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.upgradeablespawners.hikari.pool.HikariPool;
import me.angeschossen.upgradeablespawners.slf4j.LoggerFactory;

public class HikariDataSource
extends HikariConfig
implements Closeable,
DataSource {
    private static final me.angeschossen.upgradeablespawners.slf4j.Logger bm = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean bn = new AtomicBoolean();
    private final HikariPool bo;
    private volatile HikariPool bp;

    public HikariDataSource() {
        this.bo = null;
    }

    public HikariDataSource(HikariConfig hikariConfig) {
        hikariConfig.validate();
        hikariConfig.copyStateTo(this);
        bm.info("{} - Starting...", (Object)hikariConfig.getPoolName());
        this.bp = this.bo = new HikariPool(this);
        bm.info("{} - Start completed.", (Object)hikariConfig.getPoolName());
        this.NCvAI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.bo != null) {
            return this.bo.getConnection();
        }
        HikariPool hikariPool = this.bp;
        if (hikariPool == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                hikariPool = this.bp;
                if (hikariPool == null) {
                    this.validate();
                    bm.info("{} - Starting...", (Object)this.getPoolName());
                    try {
                        this.bp = hikariPool = new HikariPool(this);
                        this.NCvAI();
                    }
                    catch (HikariPool.PoolInitializationException poolInitializationException) {
                        if (poolInitializationException.getCause() instanceof SQLException) {
                            throw (SQLException)poolInitializationException.getCause();
                        }
                        throw poolInitializationException;
                    }
                    bm.info("{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return hikariPool.getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        HikariPool hikariPool = this.bp;
        return hikariPool != null ? hikariPool.getUnwrappedDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLogWriter(printWriter);
        }
    }

    @Override
    public void setLoginTimeout(int n) {
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLoginTimeout(n);
        }
    }

    @Override
    public int getLoginTimeout() {
        HikariPool hikariPool = this.bp;
        return hikariPool != null ? hikariPool.getUnwrappedDataSource().getLoginTimeout() : 0;
    }

    @Override
    public Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            DataSource dataSource = hikariPool.getUnwrappedDataSource();
            if (clazz.isInstance(dataSource)) {
                return (T)dataSource;
            }
            if (dataSource != null) {
                return dataSource.unwrap(clazz);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return true;
        }
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            DataSource dataSource = hikariPool.getUnwrappedDataSource();
            if (clazz.isInstance(dataSource)) {
                return true;
            }
            if (dataSource != null) {
                return dataSource.isWrapperFor(clazz);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object object) {
        boolean bl = this.getMetricRegistry() != null;
        super.setMetricRegistry(object);
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            hikariPool.setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        boolean bl = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory(metricsTrackerFactory);
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            hikariPool.setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object object) {
        boolean bl = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(object);
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            hikariPool.setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.bp != null && this.bp.poolState == 0;
    }

    public HikariPoolMXBean getHikariPoolMXBean() {
        return this.bp;
    }

    public HikariConfigMXBean getHikariConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        HikariPool hikariPool;
        if (!this.isClosed() && (hikariPool = this.bp) != null && connection.getClass().getName().startsWith("me.angeschossen.upgradeablespawners.hikari")) {
            hikariPool.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.bn.getAndSet(true)) {
            return;
        }
        HikariPool hikariPool = this.bp;
        if (hikariPool != null) {
            try {
                bm.info("{} - Shutdown initiated...", (Object)this.getPoolName());
                hikariPool.shutdown();
                bm.info("{} - Shutdown completed.", (Object)this.getPoolName());
            }
            catch (InterruptedException interruptedException) {
                bm.warn("{} - Interrupted during closing", (Object)this.getPoolName(), (Object)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.bn.get();
    }

    public String toString() {
        return "HikariDataSource (" + this.bp + ")";
    }
}

