/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.hikari;

import com.codahale.metrics.health.HealthCheckRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.angeschossen.upgradeablespawners.hikari.HikariConfigMXBean;
import me.angeschossen.upgradeablespawners.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.upgradeablespawners.hikari.util.PropertyElf;
import me.angeschossen.upgradeablespawners.hikari.util.UtilityElf;
import me.angeschossen.upgradeablespawners.slf4j.Logger;
import me.angeschossen.upgradeablespawners.slf4j.LoggerFactory;

public class HikariConfig
implements HikariConfigMXBean {
    private static final Logger au = LoggerFactory.getLogger(HikariConfig.class);
    private static final char[] av = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long aw = TimeUnit.SECONDS.toMillis(30L);
    private static final long ax = TimeUnit.SECONDS.toMillis(5L);
    private static final long ay = Long.getLong("me.angeschossen.upgradeablespawners.hikari.timeoutMs.floor", 250L);
    private static final long az = TimeUnit.MINUTES.toMillis(10L);
    private static final long aA = TimeUnit.MINUTES.toMillis(30L);
    private static final long aB = 0L;
    private static final int aC = 10;
    private static boolean aD = false;
    private volatile String aE;
    private volatile long aF;
    private volatile long aG;
    private volatile long aH;
    private volatile long aI;
    private volatile long aJ;
    private volatile int aK = -1;
    private volatile int aL = -1;
    private volatile String FkCT;
    private volatile String jiobR;
    private long aM = 1L;
    private String aN;
    private String aO;
    private String aP;
    private String aQ;
    private String aR;
    private String aS;
    private String aT;
    private String aU;
    private String aV;
    private String aW;
    private boolean aX = true;
    private boolean aY;
    private boolean aZ;
    private boolean ba;
    private boolean bb;
    private DataSource bc;
    private Properties bd = new Properties();
    private ThreadFactory be;
    private ScheduledExecutorService bf;
    private MetricsTrackerFactory bg;
    private Object bh;
    private Object bi;
    private Properties bj = new Properties();
    private long bk = 0L;
    private volatile boolean bl;

    public HikariConfig() {
        this.aJ = aA;
        this.aF = aw;
        this.aG = ax;
        this.aH = az;
        String string = System.getProperty("hikaricp.configurationFile");
        if (string != null) {
            this.Xtdze(string);
        }
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyElf.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String string) {
        this();
        this.Xtdze(string);
    }

    @Override
    public String getCatalog() {
        return this.aE;
    }

    @Override
    public void setCatalog(String string) {
        this.aE = string;
    }

    @Override
    public long getConnectionTimeout() {
        return this.aF;
    }

    @Override
    public void setConnectionTimeout(long l) {
        if (l == 0L) {
            this.aF = Integer.MAX_VALUE;
        } else {
            if (l < ay) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than " + ay + "ms");
            }
            this.aF = l;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.aH;
    }

    @Override
    public void setIdleTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.aH = l;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.aI;
    }

    @Override
    public void setLeakDetectionThreshold(long l) {
        this.aI = l;
    }

    @Override
    public long getMaxLifetime() {
        return this.aJ;
    }

    @Override
    public void setMaxLifetime(long l) {
        this.aJ = l;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.aK;
    }

    @Override
    public void setMaximumPoolSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.aK = n;
    }

    @Override
    public int getMinimumIdle() {
        return this.aL;
    }

    @Override
    public void setMinimumIdle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.aL = n;
    }

    public String getPassword() {
        return this.jiobR;
    }

    @Override
    public void setPassword(String string) {
        this.jiobR = string;
    }

    public String getUsername() {
        return this.FkCT;
    }

    @Override
    public void setUsername(String string) {
        this.FkCT = string;
    }

    @Override
    public long getValidationTimeout() {
        return this.aG;
    }

    @Override
    public void setValidationTimeout(long l) {
        if (l < ay) {
            throw new IllegalArgumentException("validationTimeout cannot be less than " + ay + "ms");
        }
        this.aG = l;
    }

    public String getConnectionTestQuery() {
        return this.aO;
    }

    public void setConnectionTestQuery(String string) {
        this.Vegho();
        this.aO = string;
    }

    public String getConnectionInitSql() {
        return this.aN;
    }

    public void setConnectionInitSql(String string) {
        this.Vegho();
        this.aN = string;
    }

    public DataSource getDataSource() {
        return this.bc;
    }

    public void setDataSource(DataSource dataSource) {
        this.Vegho();
        this.bc = dataSource;
    }

    public String getDataSourceClassName() {
        return this.aP;
    }

    public void setDataSourceClassName(String string) {
        this.Vegho();
        this.aP = string;
    }

    public void addDataSourceProperty(String string, Object object) {
        this.Vegho();
        this.bd.put(string, object);
    }

    public String getDataSourceJNDI() {
        return this.aQ;
    }

    public void setDataSourceJNDI(String string) {
        this.Vegho();
        this.aQ = string;
    }

    public Properties getDataSourceProperties() {
        return this.bd;
    }

    public void setDataSourceProperties(Properties properties) {
        this.Vegho();
        this.bd.putAll((Map<?, ?>)properties);
    }

    public String getDriverClassName() {
        return this.aR;
    }

    public void setDriverClassName(String string) {
        this.Vegho();
        Class<?> clazz = this.POEN(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                au.debug("Driver class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            au.error("Failed to load driver class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load driver class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.aR = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public String getJdbcUrl() {
        return this.aT;
    }

    public void setJdbcUrl(String string) {
        this.Vegho();
        this.aT = string;
    }

    public boolean isAutoCommit() {
        return this.aX;
    }

    public void setAutoCommit(boolean bl) {
        this.Vegho();
        this.aX = bl;
    }

    public boolean isAllowPoolSuspension() {
        return this.bb;
    }

    public void setAllowPoolSuspension(boolean bl) {
        this.Vegho();
        this.bb = bl;
    }

    public long getInitializationFailTimeout() {
        return this.aM;
    }

    public void setInitializationFailTimeout(long l) {
        this.Vegho();
        this.aM = l;
    }

    public boolean isIsolateInternalQueries() {
        return this.aZ;
    }

    public void setIsolateInternalQueries(boolean bl) {
        this.Vegho();
        this.aZ = bl;
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.bg;
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (this.bh != null) {
            throw new IllegalStateException("cannot use setMetricsTrackerFactory() and setMetricRegistry() together");
        }
        this.bg = metricsTrackerFactory;
    }

    public Object getMetricRegistry() {
        return this.bh;
    }

    public void setMetricRegistry(Object object) {
        if (this.bg != null) {
            throw new IllegalStateException("cannot use setMetricRegistry() and setMetricsTrackerFactory() together");
        }
        if (object != null && !UtilityElf.safeIsAssignableFrom(object = this.yivk(object), "com.codahale.metrics.MetricRegistry") && !UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            throw new IllegalArgumentException("Class must be instance of com.codahale.metrics.MetricRegistry or io.micrometer.core.instrument.MeterRegistry");
        }
        this.bh = object;
    }

    public Object getHealthCheckRegistry() {
        return this.bi;
    }

    public void setHealthCheckRegistry(Object object) {
        this.Vegho();
        if (object != null && !((object = this.yivk(object)) instanceof HealthCheckRegistry)) {
            throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
        }
        this.bi = object;
    }

    public Properties getHealthCheckProperties() {
        return this.bj;
    }

    public void setHealthCheckProperties(Properties properties) {
        this.Vegho();
        this.bj.putAll((Map<?, ?>)properties);
    }

    public void addHealthCheckProperty(String string, String string2) {
        this.Vegho();
        this.bj.setProperty(string, string2);
    }

    public long getKeepaliveTime() {
        return this.bk;
    }

    public void setKeepaliveTime(long l) {
        this.bk = l;
    }

    public boolean isReadOnly() {
        return this.aY;
    }

    public void setReadOnly(boolean bl) {
        this.Vegho();
        this.aY = bl;
    }

    public boolean isRegisterMbeans() {
        return this.ba;
    }

    public void setRegisterMbeans(boolean bl) {
        this.Vegho();
        this.ba = bl;
    }

    @Override
    public String getPoolName() {
        return this.aU;
    }

    public void setPoolName(String string) {
        this.Vegho();
        this.aU = string;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.bf;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.Vegho();
        this.bf = scheduledExecutorService;
    }

    public String getTransactionIsolation() {
        return this.aW;
    }

    public String getSchema() {
        return this.aV;
    }

    public void setSchema(String string) {
        this.Vegho();
        this.aV = string;
    }

    public String getExceptionOverrideClassName() {
        return this.aS;
    }

    public void setExceptionOverrideClassName(String string) {
        this.Vegho();
        Class<?> clazz = this.POEN(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                au.debug("SQLExceptionOverride class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            au.error("Failed to load SQLExceptionOverride class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load SQLExceptionOverride class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.aS = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public void setTransactionIsolation(String string) {
        this.Vegho();
        this.aW = string;
    }

    public ThreadFactory getThreadFactory() {
        return this.be;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.Vegho();
        this.be = threadFactory;
    }

    void NCvAI() {
        this.bl = true;
    }

    public void copyStateTo(HikariConfig hikariConfig) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(hikariConfig, field.get(this));
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to copy HikariConfig state: " + exception.getMessage(), exception);
            }
        }
        hikariConfig.bl = false;
    }

    private Class<?> POEN(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                au.debug("Driver class {} found in Thread context class loader {}", (Object)string, (Object)classLoader);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                au.debug("Driver class {} not found in Thread context class loader {}, trying classloader {}", string, classLoader, this.getClass().getClassLoader());
            }
        }
        return null;
    }

    public void validate() {
        if (this.aU == null) {
            this.aU = this.BjgCE();
        } else if (this.ba && this.aU.contains(":")) {
            throw new IllegalArgumentException("poolName cannot contain ':' when used with JMX");
        }
        this.aE = UtilityElf.getNullIfEmpty(this.aE);
        this.aN = UtilityElf.getNullIfEmpty(this.aN);
        this.aO = UtilityElf.getNullIfEmpty(this.aO);
        this.aW = UtilityElf.getNullIfEmpty(this.aW);
        this.aP = UtilityElf.getNullIfEmpty(this.aP);
        this.aQ = UtilityElf.getNullIfEmpty(this.aQ);
        this.aR = UtilityElf.getNullIfEmpty(this.aR);
        this.aT = UtilityElf.getNullIfEmpty(this.aT);
        if (this.bc != null) {
            if (this.aP != null) {
                au.warn("{} - using dataSource and ignoring dataSourceClassName.", (Object)this.aU);
            }
        } else if (this.aP != null) {
            if (this.aR != null) {
                au.error("{} - cannot use driverClassName and dataSourceClassName together.", (Object)this.aU);
                throw new IllegalStateException("cannot use driverClassName and dataSourceClassName together.");
            }
            if (this.aT != null) {
                au.warn("{} - using dataSourceClassName and ignoring jdbcUrl.", (Object)this.aU);
            }
        } else if (this.aT == null && this.aQ == null) {
            if (this.aR != null) {
                au.error("{} - jdbcUrl is required with driverClassName.", (Object)this.aU);
                throw new IllegalArgumentException("jdbcUrl is required with driverClassName.");
            }
            au.error("{} - dataSource or dataSourceClassName or jdbcUrl is required.", (Object)this.aU);
            throw new IllegalArgumentException("dataSource or dataSourceClassName or jdbcUrl is required.");
        }
        this.OCWhd();
        if (au.isDebugEnabled() || aD) {
            this.TYAxA();
        }
    }

    private void OCWhd() {
        if (this.aJ != 0L && this.aJ < TimeUnit.SECONDS.toMillis(30L)) {
            au.warn("{} - maxLifetime is less than 30000ms, setting to default {}ms.", (Object)this.aU, (Object)aA);
            this.aJ = aA;
        }
        if (this.bk != 0L && this.bk < TimeUnit.SECONDS.toMillis(30L)) {
            au.warn("{} - keepaliveTime is less than 30000ms, disabling it.", (Object)this.aU);
            this.bk = 0L;
        }
        if (this.bk != 0L && this.aJ != 0L && this.bk >= this.aJ) {
            au.warn("{} - keepaliveTime is greater than or equal to maxLifetime, disabling it.", (Object)this.aU);
            this.bk = 0L;
        }
        if (this.aI > 0L && !aD && (this.aI < TimeUnit.SECONDS.toMillis(2L) || this.aI > this.aJ && this.aJ > 0L)) {
            au.warn("{} - leakDetectionThreshold is less than 2000ms or more than maxLifetime, disabling it.", (Object)this.aU);
            this.aI = 0L;
        }
        if (this.aF < ay) {
            au.warn("{} - connectionTimeout is less than {}ms, setting to {}ms.", this.aU, ay, aw);
            this.aF = aw;
        }
        if (this.aG < ay) {
            au.warn("{} - validationTimeout is less than {}ms, setting to {}ms.", this.aU, ay, ax);
            this.aG = ax;
        }
        if (this.aK < 1) {
            this.aK = 10;
        }
        if (this.aL < 0 || this.aL > this.aK) {
            this.aL = this.aK;
        }
        if (this.aH + TimeUnit.SECONDS.toMillis(1L) > this.aJ && this.aJ > 0L && this.aL < this.aK) {
            au.warn("{} - idleTimeout is close to or more than maxLifetime, disabling it.", (Object)this.aU);
            this.aH = 0L;
        } else if (this.aH != 0L && this.aH < TimeUnit.SECONDS.toMillis(10L) && this.aL < this.aK) {
            au.warn("{} - idleTimeout is less than 10000ms, setting to default {}ms.", (Object)this.aU, (Object)az);
            this.aH = az;
        } else if (this.aH != az && this.aH != 0L && this.aL == this.aK) {
            au.warn("{} - idleTimeout has been set but has no effect because the pool is operating as a fixed size pool.", (Object)this.aU);
        }
    }

    private void Vegho() {
        if (this.bl) {
            throw new IllegalStateException("The configuration of the pool is sealed once started. Use HikariConfigMXBean for runtime changes.");
        }
    }

    private void TYAxA() {
        au.debug("{} - configuration:", (Object)this.aU);
        TreeSet<String> treeSet = new TreeSet<String>(PropertyElf.getPropertyNames(HikariConfig.class));
        for (String string : treeSet) {
            try {
                Object object = PropertyElf.getProperty(string, this);
                if ("dataSourceProperties".equals(string)) {
                    Properties properties = PropertyElf.copyProperties(this.bd);
                    properties.setProperty("password", "<masked>");
                    object = properties;
                }
                if ("initializationFailTimeout".equals(string) && this.aM == Long.MAX_VALUE) {
                    object = "infinite";
                } else if ("transactionIsolation".equals(string) && this.aW == null) {
                    object = "default";
                } else if (string.matches("scheduledExecutorService|threadFactory") && object == null) {
                    object = "internal";
                } else if (string.contains("jdbcUrl") && object instanceof String) {
                    object = ((String)object).replaceAll("([?&;]password=)[^&#;]*(.*)", "$1<masked>$2");
                } else if (string.contains("password")) {
                    object = "<masked>";
                } else if (object instanceof String) {
                    object = "\"" + object + "\"";
                } else if (object == null) {
                    object = "none";
                }
                au.debug("{}{}", (Object)(string + "................................................".substring(0, 32)), object);
            }
            catch (Exception exception) {}
        }
    }

    private void Xtdze(String string) {
        block9: {
            File file = new File(string);
            try (InputStream inputStream = file.isFile() ? new FileInputStream(file) : this.getClass().getResourceAsStream(string);){
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    PropertyElf.setTargetFromProperties(this, properties);
                    break block9;
                }
                throw new IllegalArgumentException("Cannot find property file: " + string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read property file", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String BjgCE() {
        String string = "HikariPool-";
        try {
            Properties properties = System.getProperties();
            synchronized (properties) {
                String string2 = String.valueOf(Integer.getInteger("me.angeschossen.upgradeablespawners.hikari.pool_number", 0) + 1);
                System.setProperty("me.angeschossen.upgradeablespawners.hikari.pool_number", string2);
                return "HikariPool-" + string2;
            }
        }
        catch (AccessControlException accessControlException) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            StringBuilder stringBuilder = new StringBuilder("HikariPool-");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(av[threadLocalRandom.nextInt(62)]);
            }
            au.info("assigned random pool name '{}' (security manager prevented access to system properties)", (Object)stringBuilder);
            return stringBuilder.toString();
        }
    }

    private Object yivk(Object object) {
        if (object instanceof String) {
            try {
                InitialContext initialContext = new InitialContext();
                return initialContext.lookup((String)object);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException);
            }
        }
        return object;
    }
}

