/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.api.role;

import java.util.HashMap;
import java.util.Map;
import me.angeschossen.upgradeablespawners.api.framework.roles.settings.ManagementSetting;
import me.angeschossen.upgradeablespawners.api.framework.roles.settings.SettingType;
import org.jetbrains.annotations.NotNull;

public enum ManagementFlag implements ManagementSetting
{
    DELETE(0, false),
    EDIT(1, true);

    private static final Map<Integer, ManagementFlag> map;
    private final int id;
    public final boolean regionMembers;

    private ManagementFlag(int n2, boolean bl) {
        this.regionMembers = bl;
        this.id = n2;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getBypassPermission() {
        return "uspawners.bypass." + this.toString();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public SettingType getType() {
        return SettingType.MANAGEMENT;
    }

    @Override
    public String getTogglePermission() {
        return "uspawners.setting." + this.toString();
    }

    @Override
    public String getMessageKey() {
        return "noaccess.edit";
    }

    @NotNull
    public static ManagementFlag getById(int n) {
        if (map.containsKey(n)) {
            return map.get(n);
        }
        throw new IllegalArgumentException("Could not find ManagementSetting with id " + n + ".");
    }

    static {
        map = new HashMap<Integer, ManagementFlag>();
        for (ManagementFlag managementFlag : ManagementFlag.values()) {
            map.put(managementFlag.id, managementFlag);
        }
    }
}

