/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.api.handler;

import java.util.Objects;
import java.util.concurrent.Callable;
import me.angeschossen.upgradeablespawners.api.UpgradeableSpawnersAPI;
import me.angeschossen.upgradeablespawners.api.framework.configuration.Configuration;
import me.angeschossen.upgradeablespawners.api.framework.configuration.gui.GUIConfiguration;
import me.angeschossen.upgradeablespawners.api.framework.configuration.messages.Messages;
import me.angeschossen.upgradeablespawners.api.framework.utils.StringUtils;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class APIHandler {
    private static APIHandler instance;
    @NotNull
    private final Configuration config;
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Callable<GUIConfiguration> guiConfiguration;
    @NotNull
    private final Callable<Messages> messages;
    @NotNull
    private final StringUtils stringUtils;
    @NotNull
    private final UpgradeableSpawnersAPI api;

    @NotNull
    public Configuration getConfig() {
        return this.config;
    }

    private APIHandler(@NotNull Plugin plugin, @NotNull Configuration configuration, @NotNull Callable<Messages> callable, @NotNull Callable<GUIConfiguration> callable2, @NotNull StringUtils stringUtils, @NotNull UpgradeableSpawnersAPI upgradeableSpawnersAPI) {
        this.config = configuration;
        this.api = upgradeableSpawnersAPI;
        this.plugin = plugin;
        this.messages = callable;
        this.guiConfiguration = callable2;
        this.stringUtils = stringUtils;
    }

    @NotNull
    public UpgradeableSpawnersAPI getAPI() {
        return this.api;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public GUIConfiguration getGUIConfiguration() {
        try {
            return this.guiConfiguration.call();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @NotNull
    public Messages getMessages() {
        try {
            return this.messages.call();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @NotNull
    public StringUtils getStringUtils() {
        return this.stringUtils;
    }

    public static APIHandler getInstance() {
        return instance;
    }

    public static void init(@NotNull Plugin plugin, @NotNull Configuration configuration, @NotNull Callable<Messages> callable, @NotNull Callable<GUIConfiguration> callable2, @NotNull StringUtils stringUtils, @NotNull UpgradeableSpawnersAPI upgradeableSpawnersAPI) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(upgradeableSpawnersAPI);
        if (instance != null) {
            throw new IllegalStateException("Already initialized.");
        }
        instance = new APIHandler(plugin, configuration, callable, callable2, stringUtils, upgradeableSpawnersAPI);
    }
}

