/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.api.framework.trusted;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.angeschossen.upgradeablespawners.api.framework.roles.settings.ManagementSetting;
import me.angeschossen.upgradeablespawners.api.framework.roles.settings.RoleSetting;
import me.angeschossen.upgradeablespawners.api.framework.roles.settings.Setting;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public enum SimpleRole {
    OWNER(0, 100),
    ADMIN(1, 99),
    MEMBER(2, 98),
    VISITOR(3, 0);

    private static final Map<Integer, SimpleRole> map;
    private final int id;
    private final int priority;
    private Set<ManagementSetting> managementSettings = new HashSet<ManagementSetting>();
    private Set<RoleSetting> roleSettings = new HashSet<RoleSetting>();
    private String name;
    private String name_plain;

    private SimpleRole(int n2, int n3) {
        this.id = n2;
        this.priority = n3;
        this.name_plain = this.name = this.toString();
    }

    public static SimpleRole getById(int n) {
        return map.getOrDefault(n, MEMBER);
    }

    public void allow(ManagementSetting managementSetting) {
        this.managementSettings.add(managementSetting);
    }

    public void allow(RoleSetting roleSetting) {
        this.roleSettings.add(roleSetting);
    }

    public boolean canManagement(Player player, ManagementSetting managementSetting) {
        return this.hasManagement(managementSetting) || player.hasPermission(managementSetting.getBypassPermission());
    }

    public boolean canRoleSetting(Player player, RoleSetting roleSetting) {
        return this.hasRoleSetting(roleSetting) || player.hasPermission(roleSetting.getBypassPermission());
    }

    public SimpleRole getDemote() {
        SimpleRole simpleRole = SimpleRole.getById(this.getId() + 1);
        return simpleRole != VISITOR ? simpleRole : null;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string = string.replace(" ", "");
        this.name_plain = ChatColor.stripColor((String)string);
    }

    public String getNamePlain() {
        return this.name_plain;
    }

    public int getPriority() {
        return this.priority;
    }

    public SimpleRole getPromote() {
        SimpleRole simpleRole = SimpleRole.getById(this.getId() - 1);
        return simpleRole != OWNER ? simpleRole : null;
    }

    public boolean hasManagement(ManagementSetting managementSetting) {
        return this.managementSettings.contains(managementSetting);
    }

    public boolean hasRoleSetting(RoleSetting roleSetting) {
        return this.roleSettings.contains(roleSetting);
    }

    public void setManagementSettings(Set<? extends Setting> set) {
        this.managementSettings = set;
    }

    public void setRoleSettings(Set<? extends Setting> set) {
        this.roleSettings = set;
    }

    static {
        map = new HashMap<Integer, SimpleRole>();
        for (SimpleRole simpleRole : SimpleRole.values()) {
            map.put(simpleRole.id, simpleRole);
        }
    }
}

