/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.api.framework.blockutil.impl;

import com.google.gson.JsonObject;
import me.angeschossen.upgradeablespawners.api.framework.blockutil.impl.BlockPosition;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Position
extends BlockPosition {
    private final float yaw;
    private final float pitch;

    public Position(World world, int n, int n2, int n3, float f, float f2) {
        super(world, n, n2, n3);
        this.pitch = f2;
        this.yaw = f;
    }

    public Position(Location location) {
        super(location);
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
    }

    @Nullable
    public static Position fromJson(JsonObject jsonObject) {
        World world = Bukkit.getWorld((String)jsonObject.get("world").getAsString());
        if (world == null) {
            return null;
        }
        return new Position(world, jsonObject.get("x").getAsInt(), jsonObject.get("y").getAsInt(), jsonObject.get("z").getAsInt(), jsonObject.get("yaw").getAsFloat(), jsonObject.get("pitch").getAsFloat());
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof Position)) {
            return false;
        }
        Position position = (Position)object;
        return position.world.equals(this.world) && position.x == this.x && position.z == this.z && position.y == this.y && this.yaw == position.yaw && this.pitch == position.pitch;
    }

    @Override
    @NotNull
    public Location toLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z, this.yaw, this.pitch);
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + (int)this.yaw;
        n = n * 31 + (int)this.pitch;
        return n;
    }

    @Override
    @NotNull
    public final JsonObject toJson() {
        JsonObject jsonObject = super.toJson();
        jsonObject.addProperty("yaw", (Number)Float.valueOf(this.yaw));
        jsonObject.addProperty("pitch", (Number)Float.valueOf(this.pitch));
        return jsonObject;
    }

    @Override
    public final String toString() {
        return "Position{world=" + this.world + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",yaw=" + this.yaw + ",pitch=" + this.pitch + '}';
    }
}

