/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.api.framework.blockutil.impl;

import com.google.gson.JsonObject;
import java.util.Objects;
import me.angeschossen.upgradeablespawners.api.framework.blockutil.UnloadedPosition;
import me.angeschossen.upgradeablespawners.api.framework.blockutil.impl.Position;
import me.angeschossen.upgradeablespawners.api.framework.handler.APIHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineBlockCoordinate
implements UnloadedPosition {
    private final String worldName;
    private final String serverName;
    private final float yaw;
    private final float pitch;
    private final double x;
    private final double y;
    private final double z;

    public OfflineBlockCoordinate(String string, String string2, double d, double d2, double d3) {
        this(string, string2, d, d2, d3, 0.0f, 0.0f);
    }

    public OfflineBlockCoordinate(Position position) {
        this(APIHandler.getInstance().getServerName(), position.world.getName(), position.x, position.y, position.z);
    }

    public OfflineBlockCoordinate(String string, String string2, double d, double d2, double d3, float f, float f2) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.serverName = string;
        this.worldName = string2;
        this.yaw = f;
        this.pitch = f2;
    }

    @Override
    public final boolean isTargetServer() {
        return APIHandler.getInstance().getMultiPaperHandler().isTargetServer(this.serverName);
    }

    public OfflineBlockCoordinate(@NotNull Location location) {
        this(APIHandler.getInstance().getServerName(), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static OfflineBlockCoordinate fromJson(@NotNull JsonObject jsonObject) {
        return new OfflineBlockCoordinate(jsonObject.has("server") ? jsonObject.get("server").getAsString() : APIHandler.getInstance().getServerName(), jsonObject.get("world").getAsString(), jsonObject.get("x").getAsDouble(), jsonObject.get("y").getAsDouble(), jsonObject.get("z").getAsDouble(), jsonObject.get("yaw").getAsFloat(), jsonObject.get("pitch").getAsFloat());
    }

    public boolean equals(String string, World world, int n, int n2, int n3) {
        if (!string.equals(this.serverName) || !world.equals(this.getWorld())) {
            return false;
        }
        return (double)n == this.x && (double)n2 == this.y && (double)n3 == this.z;
    }

    @Override
    public int getBlockX() {
        return (int)this.x;
    }

    @Override
    public int getBlockY() {
        return (int)this.y;
    }

    @Override
    public int getBlockZ() {
        return (int)this.z;
    }

    @Override
    public int getChunkX() {
        return (int)this.x >> 4;
    }

    @Override
    public int getChunkZ() {
        return (int)this.z >> 4;
    }

    @Override
    @Nullable
    public final Location toLocation() {
        if (!this.isTargetServer()) {
            return null;
        }
        World world = this.getWorld();
        return world == null ? null : new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @Override
    @Nullable
    public final World getWorld() {
        return this.isTargetServer() ? Bukkit.getWorld((String)this.getWorldName()) : null;
    }

    @NotNull
    public final World getWorldNotNull() {
        return Objects.requireNonNull(this.getWorld(), "expected world");
    }

    @Override
    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isChunkLoaded() {
        if (!this.isTargetServer()) {
            return false;
        }
        World world = this.getWorld();
        if (world == null) {
            return false;
        }
        return world.isChunkLoaded(this.getChunkX(), this.getChunkZ());
    }

    @Override
    public boolean isWorldLoaded() {
        return this.getWorld() != null;
    }

    @Override
    public boolean isSameWorld(@NotNull String string) {
        return this.isTargetServer() && string.equalsIgnoreCase(this.worldName);
    }

    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server", this.serverName);
        jsonObject.addProperty("world", this.worldName);
        jsonObject.addProperty("x", (Number)this.x);
        jsonObject.addProperty("y", (Number)this.y);
        jsonObject.addProperty("z", (Number)this.z);
        jsonObject.addProperty("yaw", (Number)Float.valueOf(this.yaw));
        jsonObject.addProperty("pitch", (Number)Float.valueOf(this.pitch));
        return jsonObject;
    }
}

