/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablespawners.api.framework.blockutil.impl;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class BlockKey
implements me.angeschossen.upgradeablespawners.api.framework.blockutil.BlockKey {
    private final int x;
    private final int y;
    private final int z;
    private final World world;

    public BlockKey(@NotNull World world, int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.world = world;
    }

    public BlockKey(@NotNull Location location) {
        this(Objects.requireNonNull(location.getWorld(), "world must not be null"), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public final Location toLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    public final int getChunkX() {
        return this.x >> 4;
    }

    @Override
    public final int getChunkZ() {
        return this.z >> 4;
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlockKey)) {
            return false;
        }
        BlockKey blockKey = (BlockKey)object;
        return blockKey.x == this.x && blockKey.y == this.y && blockKey.z == this.z;
    }
}

