/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.select;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuSelectMaterial
extends Menu {
    private Material value;
    private final boolean allowNull;
    private final String filterName;
    private final Function<Material, Boolean> filter;
    private final BiConsumer<MenuSelectMaterial, Material> setFunc;

    public MenuSelectMaterial(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, String filterName, Material defaultValue, Function<Material, Boolean> filter, BiConsumer<MenuSelectMaterial, Material> setFunc) {
        super(parent, plugin, player, "Select Material (" + name + ")", 9);
        this.value = defaultValue;
        this.allowNull = allowNull;
        this.filterName = filterName;
        this.refresh();
        this.filter = filter;
        this.setFunc = setFunc;
    }

    public void refresh() {
        this.components.clear();
        ItemBuilder builder = this.makeItem(this.value == null ? Material.BLACK_CONCRETE : this.value).addLore("Click any " + this.filterName + " in your inventory to set the material.");
        if (this.value == null) {
            builder.setDisplayName("NULL");
        }
        if (this.allowNull) {
            builder.addLore("Right click this item to set to NULL");
        }
        this.add(new Button(0, builder, click -> {
            if (click == ClickType.RIGHT) {
                if (this.allowNull) {
                    this.value = null;
                }
                this.refresh();
            }
        }));
        this.add(new Button(this.size - 1, this.makeItem(this.value == null ? Material.BARRIER : Material.GREEN_CONCRETE).setDisplayName(this.value == null ? "Back" : "Select"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            if (this.value != null) {
                this.setFunc.accept(this, this.value);
            } else {
                this.open(this.parent);
            }
        }));
        this.updateInventory();
    }

    @Override
    public void onInventoryClick(int slot, ClickType click) {
        if (click != ClickType.LEFT) {
            return;
        }
        ItemStack stack = this.player.getInventory().getItem(slot);
        if (stack == null) {
            return;
        }
        if (this.filter.apply(stack.getType()).booleanValue()) {
            this.value = stack.getType();
            this.refresh();
        }
    }
}

