/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.select;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuSelectEnum<T>
extends Menu {
    T value;
    private final T[] values;
    private final boolean allowNull;
    private final BiConsumer<MenuSelectEnum<T>, T> setFunc;

    public MenuSelectEnum(Menu parent, Plugin plugin, Player player, String name, String enumName, boolean allowNull, T defaultValue, T[] values, BiConsumer<MenuSelectEnum<T>, T> setFunc) {
        super(parent, plugin, player, "Select " + enumName + " (" + name + ")", MenuSelectEnum.getSize(values.length, allowNull));
        this.value = defaultValue;
        this.values = values;
        this.allowNull = allowNull;
        this.setFunc = setFunc;
        this.refresh();
    }

    private void refresh() {
        this.components.clear();
        this.add(new Label(0, this.makeItem(Material.PAPER).setDisplayName(Objects.toString(this.value))));
        for (int i = 0; i < this.values.length; ++i) {
            int idx = i;
            this.add(new Button(i + 1, this.makeItem(this.getItem(this.values[i])).setDisplayName("Set to " + Objects.toString(this.values[i])), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = this.values[idx];
                this.refresh();
            }));
        }
        if (this.allowNull) {
            this.add(new Button(this.values.length + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(this.value == null ? Material.BARRIER : Material.GREEN_CONCRETE).setDisplayName(this.value == null ? "Back" : "Select"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            if (this.value != null) {
                this.setFunc.accept(this, (MenuSelectEnum)this.value);
            } else {
                this.open(this.parent);
            }
        }));
        this.updateInventory();
    }

    public Material getItem(T value) {
        return Material.PAPER;
    }

    private static int getSize(int count, boolean allowNull) {
        int actualCount = count + 2;
        if (allowNull) {
            ++actualCount;
        }
        if (actualCount > 54) {
            throw new IllegalArgumentException("MenuSelectEnum only supports up to 52 values! (including null)");
        }
        if (actualCount / 9 * 9 == actualCount) {
            return actualCount;
        }
        return actualCount / 9 * 9 + 9;
    }
}

