/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify.special;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyTreeSet
extends Menu {
    private HashSet<Tree> value;
    private final boolean allowNull;
    private final Consumer<HashSet<Tree>> setFunc;

    public MenuModifyTreeSet(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, Collection<Tree> defaultValue, Consumer<HashSet<Tree>> setFunc) {
        super(parent, plugin, player, "Modify Tree Set (" + name + ")", MenuModifyTreeSet.getSize(allowNull));
        this.value = defaultValue == null ? null : new HashSet<Tree>(defaultValue);
        this.allowNull = allowNull;
        this.refresh();
        this.setFunc = setFunc;
    }

    private void refresh() {
        this.components.clear();
        ItemBuilder builder = this.makeItem(Material.PAPER).setDisplayName(this.value == null ? "null" : this.value.size() + " trees:");
        if (this.value != null) {
            for (Tree t : TreeFeller.trees) {
                if (!this.value.contains(t)) continue;
                builder.addLore("Tree #" + TreeFeller.trees.indexOf(t));
            }
        }
        this.add(new Label(0, builder));
        for (int i = 0; i < Math.min(this.allowNull ? 51 : 52, TreeFeller.trees.size()); ++i) {
            Tree tree = TreeFeller.trees.get(i);
            boolean added = false;
            if (this.value != null) {
                added = this.value.contains(tree);
            }
            this.add(new Button(i + 1, this.makeItem(tree.getDisplayMaterial()).setDisplayName("Tree #" + i).addLore("Left click to add this tree").addLore("Right click to remove this tree").addLore(added ? "Added" : "Not Added"), click -> {
                if (click == ClickType.LEFT) {
                    if (this.value == null) {
                        this.value = new HashSet();
                    }
                    this.value.add(tree);
                    this.setFunc.accept(this.value);
                }
                if (click == ClickType.RIGHT) {
                    if (this.value == null) {
                        this.value = new HashSet();
                    }
                    this.value.remove(tree);
                    this.setFunc.accept(this.value);
                }
                this.refresh();
            }));
        }
        if (this.allowNull) {
            this.add(new Button(TreeFeller.trees.size() + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }

    private static int getSize(boolean allowNull) {
        int actualCount = TreeFeller.trees.size() + 2;
        if (allowNull) {
            ++actualCount;
        }
        if (actualCount > 54) {
            throw new IllegalArgumentException("MenuModifyTrees only supports up to " + (allowNull ? 51 : 52) + " values!");
        }
        if (actualCount / 9 * 9 == actualCount) {
            return actualCount;
        }
        return actualCount / 9 * 9 + 9;
    }
}

