/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify.special;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.FellBehavior;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyFellBehavior
extends Menu {
    public MenuModifyFellBehavior(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, FellBehavior defaultValue, FellBehavior[] values, Consumer<FellBehavior> setFunc) {
        super(parent, plugin, player, "Modify Fell Behavior (" + name + ")", MenuModifyFellBehavior.getSize(values.length, allowNull));
        Label label = this.add(new Label(0, this.makeItem(Material.PAPER).setDisplayName(Objects.toString((Object)defaultValue))));
        for (int i = 0; i < values.length; ++i) {
            int idx = i;
            this.add(new Button(i + 1, this.makeItem(values[i].getItem()).setDisplayName("Set to " + Objects.toString((Object)values[i])).addLore(this.shorten(values[i].getDescription(), 42)), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                setFunc.accept(values[idx]);
                label.label = this.makeItem(Material.PAPER).setDisplayName(Objects.toString((Object)values[idx])).build();
                this.updateInventory();
            }));
        }
        if (allowNull) {
            this.add(new Button(values.length + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                setFunc.accept(null);
                label.label = this.makeItem(Material.PAPER).setDisplayName(Objects.toString(null)).build();
                this.updateInventory();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(parent);
        }));
    }

    private ArrayList<String> shorten(String s, int chars) {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(s);
        return this.shorten(strs, chars);
    }

    private ArrayList<String> shorten(ArrayList<String> description, int chars) {
        ArrayList<String> output = new ArrayList<String>();
        for (String s : description) {
            String[] split = s.split(" ");
            String str = "";
            for (int i = 0; i < split.length; ++i) {
                if ((str = str + " " + split[i]).length() <= chars) continue;
                output.add(str.trim());
                str = "";
            }
            if (str.trim().isEmpty()) continue;
            output.add(str.trim());
        }
        return output;
    }

    private static int getSize(int count, boolean allowNull) {
        int actualCount = count + 2;
        if (allowNull) {
            ++actualCount;
        }
        if (actualCount > 54) {
            throw new IllegalArgumentException("MenuModifyFellBehavior only supports up to 52 values! (including null)");
        }
        if (actualCount / 9 * 9 == actualCount) {
            return actualCount;
        }
        return actualCount / 9 * 9 + 9;
    }
}

