/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify.special;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Effect;
import com.thizthizzydizzy.treefeller.TreeFeller;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyEffectList
extends Menu {
    private ArrayList<Effect> value;
    private final boolean allowNull;
    private final Consumer<ArrayList<Effect>> setFunc;

    public MenuModifyEffectList(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, ArrayList<Effect> defaultValue, Consumer<ArrayList<Effect>> setFunc) {
        super(parent, plugin, player, "Modify Effect List (" + name + ")", MenuModifyEffectList.getSize(allowNull));
        this.value = defaultValue;
        this.allowNull = allowNull;
        this.refresh();
        this.setFunc = setFunc;
    }

    private void refresh() {
        this.components.clear();
        ItemBuilder builder = this.makeItem(Material.PAPER).setDisplayName(this.value == null ? "null" : this.value.size() + " effects:");
        if (this.value != null) {
            HashMap<Effect, Integer> quantities = new HashMap<Effect, Integer>();
            for (Effect e : this.value) {
                quantities.put(e, quantities.containsKey(e) ? (Integer)quantities.get(e) + 1 : 1);
            }
            for (Effect e : quantities.keySet()) {
                builder.addLore(e.name + " (" + quantities.get(e) + ")");
            }
        }
        this.add(new Label(0, builder));
        for (int i = 0; i < Math.min(this.allowNull ? 51 : 52, TreeFeller.effects.size()); ++i) {
            Effect effect = TreeFeller.effects.get(i);
            int count = 0;
            if (this.value != null) {
                for (Effect e : this.value) {
                    if (e != effect) continue;
                    ++count;
                }
            }
            this.add(new Button(i + 1, this.makeItem(effect.type.getItem()).setDisplayName(effect.name).setCount(count).addLore("Left click to add this effect").addLore("Right click to remove this effect").addLore("Currently added: " + count), click -> {
                if (click == ClickType.LEFT) {
                    if (this.value == null) {
                        this.value = new ArrayList();
                    }
                    this.value.add(effect);
                    this.setFunc.accept(this.value);
                }
                if (click == ClickType.RIGHT) {
                    if (this.value == null) {
                        this.value = new ArrayList();
                    }
                    this.value.remove(effect);
                    this.setFunc.accept(this.value);
                }
                this.refresh();
            }));
        }
        if (this.allowNull) {
            this.add(new Button(TreeFeller.effects.size() + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }

    private static int getSize(boolean allowNull) {
        int actualCount = TreeFeller.effects.size() + 2;
        if (allowNull) {
            ++actualCount;
        }
        if (actualCount > 54) {
            throw new IllegalArgumentException("MenuModifyEffects only supports up to " + (allowNull ? 51 : 52) + " values!");
        }
        if (actualCount / 9 * 9 == actualCount) {
            return actualCount;
        }
        return actualCount / 9 * 9 + 9;
    }
}

