/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyStringList
extends Menu {
    private ArrayList<String> value;
    private final Consumer<ArrayList<String>> setFunc;
    private final boolean allowNull;

    public MenuModifyStringList(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, ArrayList<String> defaultValue, Consumer<ArrayList<String>> setFunc) {
        super(parent, plugin, player, "Modify String List (" + name + ")", 54);
        this.value = defaultValue;
        this.setFunc = setFunc;
        this.allowNull = allowNull;
        this.refresh();
    }

    public void refresh() {
        this.components.clear();
        this.add(new Button(0, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("Click to add a String"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.openAnvilGUI("", "Add String", (p, str) -> {
                if (this.value == null) {
                    this.value = new ArrayList();
                }
                this.value.add((String)str);
                this.setFunc.accept(this.value);
                this.refresh();
            });
        }));
        if (this.value != null) {
            for (int i = 0; i < Math.min(this.value.size(), this.allowNull ? 51 : 52); ++i) {
                int idx = i;
                this.add(new Button(i + 1, this.makeItem(Material.PAPER).setDisplayName(this.value.get(i)), click -> {
                    if (click != ClickType.RIGHT) {
                        return;
                    }
                    this.value.remove(idx);
                    this.setFunc.accept(this.value);
                    this.refresh();
                }));
            }
        }
        if (this.allowNull) {
            this.add(new Button(this.value == null ? 1 : this.value.size() + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }
}

