/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyStringDoubleMap
extends Menu {
    private HashMap<String, Double> value;
    private final Consumer<HashMap<String, Double>> setFunc;
    private final double max;
    private final boolean allowNull;
    private final double min;
    private final boolean allowNullDoubles;

    public MenuModifyStringDoubleMap(Menu parent, Plugin plugin, Player player, String name, double min, double max, boolean allowNull, boolean allowNullDoubles, HashMap<String, Double> defaultValue, Consumer<HashMap<String, Double>> setFunc) {
        super(parent, plugin, player, "Modify String-Double Map (" + name + ")", 54);
        this.value = defaultValue;
        this.setFunc = setFunc;
        this.min = min;
        this.max = max;
        this.allowNull = allowNull;
        this.allowNullDoubles = allowNullDoubles;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    public void refresh() {
        this.components.clear();
        this.add(new Button(0, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("Click to add a String"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.openAnvilGUI("", "Add String", (p, str) -> {
                if (this.value == null) {
                    this.value = new HashMap();
                }
                this.value.put((String)str, Math.min(this.max, Math.max(this.min, 0.0)));
                this.setFunc.accept(this.value);
                this.refresh();
            });
        }));
        if (this.value != null) {
            ArrayList<String> strs = new ArrayList<String>(this.value.keySet());
            Collections.sort(strs);
            for (int i = 0; i < Math.min(this.value.size(), this.allowNull ? 51 : 52); ++i) {
                int idx = i;
                this.add(new Button(i + 1, this.makeItem(Material.PAPER).setDisplayName(strs.get(i) + " (" + this.value.get(strs.get(i)) + ")").addLore("Left click to modify").addLore("Right click to remove"), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, "Modify " + (String)strs.get(idx), this.min, this.max, this.allowNullDoubles, this.value.get(strs.get(idx)), value -> this.value.put((String)strs.get(idx), (Double)value)));
                    }
                    if (click == ClickType.RIGHT) {
                        this.value.remove(strs.get(idx));
                        this.setFunc.accept(this.value);
                        this.refresh();
                    }
                }));
            }
        }
        if (this.allowNull) {
            this.add(new Button(this.value == null ? 1 : this.value.size() + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }
}

