/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuModifyMaterialSet
extends Menu {
    private HashSet<Material> value;
    private final boolean allowNull;
    private final String filterName;
    private final Function<Material, Boolean> filter;
    private final Consumer<HashSet<Material>> setFunc;

    public MenuModifyMaterialSet(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, String filterName, HashSet<Material> defaultValue, Function<Material, Boolean> filter, Consumer<HashSet<Material>> setFunc) {
        super(parent, plugin, player, "Modify Material Set (" + name + ")", 54);
        this.value = defaultValue == null ? null : (HashSet)defaultValue.clone();
        this.allowNull = allowNull;
        this.filterName = filterName;
        this.refresh();
        this.filter = filter;
        this.setFunc = setFunc;
    }

    public void refresh() {
        this.components.clear();
        this.add(new Button(0, this.makeItem(Material.PAPER).setDisplayName(this.value == null ? "NULL" : this.value.size() + " " + this.filterName + (this.value.size() == 1 ? "" : "s")).addLore("Click a " + this.filterName + " in your inventory to add it to the list.").addLore("Right click any " + this.filterName + " in the list to remove it.").addLore(this.allowNull ? "Shift-right click this item to set to NULL" : "Shift-right click this item to clear all " + this.filterName + "s"), click -> {
            if (click == ClickType.SHIFT_RIGHT) {
                if (this.allowNull) {
                    this.value = null;
                } else {
                    if (this.value == null) {
                        this.value = new HashSet();
                    }
                    this.value.clear();
                }
                this.setFunc.accept(this.value);
                this.refresh();
            }
        }));
        if (this.value != null) {
            ArrayList<Material> lst = new ArrayList<Material>(this.value);
            Collections.sort(lst);
            for (int i = 0; i < Math.min(51, lst.size()); ++i) {
                int idx = i;
                Material m = lst.get(i);
                this.add(new Button(i + 1, m.isItem() ? this.makeItem(m) : this.makeItem(Material.PAPER).setDisplayName(m.toString()), click -> {
                    if (click == ClickType.RIGHT) {
                        this.value.remove(lst.get(idx));
                        this.setFunc.accept(this.value);
                        this.refresh();
                    }
                }));
            }
            if (lst.size() >= 52) {
                ItemBuilder b = this.makeItem(Material.PAPER);
                b.setDisplayName(lst.size() - 51 + " More...");
                for (int i = 52; i < lst.size(); ++i) {
                    b.addLore(lst.get(i).toString());
                }
                this.add(new Label(52, b));
            }
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }

    @Override
    public void onInventoryClick(int slot, ClickType click) {
        if (click != ClickType.LEFT) {
            return;
        }
        ItemStack stack = this.player.getInventory().getItem(slot);
        if (stack == null) {
            return;
        }
        if (this.filter.apply(stack.getType()).booleanValue()) {
            if (this.value == null) {
                this.value = new HashSet();
            }
            this.value.add(stack.getType());
            this.setFunc.accept(this.value);
            this.refresh();
        }
    }
}

