/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuModifyMaterialMaterialMap
extends Menu {
    private HashMap<Material, Material> value;
    private final boolean allowNull;
    private final String keyFilterName;
    private final Predicate<Material> keyFilter;
    private final String valueFilterName;
    private final Predicate<Material> valueFilter;
    private final Consumer<HashMap<Material, Material>> setFunc;
    private Material selected = null;

    public MenuModifyMaterialMaterialMap(Menu parent, Plugin plugin, Player player, String name, String keyFilterName, Predicate<Material> keyFilter, String valueFilterName, Predicate<Material> valueFilter, boolean allowNull, HashMap<Material, Material> defaultValue, Consumer<HashMap<Material, Material>> setFunc) {
        super(parent, plugin, player, "Modify Material Map (" + name + ")", 54);
        this.value = defaultValue;
        this.setFunc = setFunc;
        this.valueFilter = valueFilter;
        this.allowNull = allowNull;
        this.keyFilterName = keyFilterName;
        this.keyFilter = keyFilter;
        this.valueFilterName = valueFilterName;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    public void refresh() {
        this.components.clear();
        if (this.selected == null) {
            this.add(new Label(0, this.makeItem(Material.PAPER).setDisplayName("Click " + this.an(this.keyFilterName) + " " + this.keyFilterName + " in your inventory to select it.")));
        } else {
            this.add(new Button(0, this.makeItem(this.selected).setDisplayName("Click " + this.an(this.valueFilterName) + " " + this.valueFilterName + " in your inventory to add them to the list.").addLore("Right click to clear selection"), click -> {
                if (click == ClickType.RIGHT) {
                    this.selected = null;
                    this.refresh();
                }
            }));
        }
        if (this.value != null) {
            ArrayList<Material> materials = new ArrayList<Material>(this.value.keySet());
            Collections.sort(materials);
            for (int i = 0; i < Math.min(this.value.size(), this.allowNull ? 51 : 52); ++i) {
                int idx = i;
                this.add(new Button(i + 1, this.makeItem(materials.get(i)).addLore("Value: " + this.value.get(materials.get(i)).toString()).addLore("Right click to remove"), click -> {
                    if (click == ClickType.RIGHT) {
                        this.value.remove(materials.get(idx));
                        this.setFunc.accept(this.value);
                        this.refresh();
                    }
                }));
            }
        }
        if (this.allowNull) {
            this.add(new Button(this.value == null ? 1 : this.value.size() + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }

    private String an(String s) {
        return (s = s.toLowerCase(Locale.ENGLISH)).startsWith("a") || s.startsWith("e") || s.startsWith("i") || s.startsWith("o") || s.startsWith("u") ? "an" : "a";
    }

    @Override
    public void onInventoryClick(int slot, ClickType click) {
        if (click != ClickType.LEFT) {
            return;
        }
        ItemStack stack = this.player.getInventory().getItem(slot);
        if (stack == null) {
            return;
        }
        if (this.selected == null) {
            if (this.keyFilter.test(stack.getType())) {
                this.selected = stack.getType();
                this.refresh();
            }
        } else if (this.valueFilter.test(stack.getType())) {
            if (this.value == null) {
                this.value = new HashMap();
            }
            this.value.put(this.selected, stack.getType());
            this.selected = null;
            this.setFunc.accept(this.value);
            this.refresh();
        }
    }
}

