/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyEnumSet<T>
extends Menu {
    private HashSet<T> value;
    private final boolean allowNull;
    private final Material[] materials;
    private final Consumer<HashSet<T>> setFunc;
    private final T[] values;

    public MenuModifyEnumSet(Menu parent, Plugin plugin, Player player, String name, String enumName, boolean allowNull, Collection<T> defaultValue, T[] values, Material[] materials, Consumer<HashSet<T>> setFunc) {
        super(parent, plugin, player, "Modify " + enumName + " Set (" + name + ")", MenuModifyEnumSet.getSize(values.length, allowNull));
        this.value = defaultValue == null ? null : new HashSet<T>(defaultValue);
        this.allowNull = allowNull;
        this.values = values;
        this.materials = materials;
        this.refresh();
        this.setFunc = setFunc;
    }

    private void refresh() {
        this.components.clear();
        ItemBuilder builder = this.makeItem(Material.PAPER).setDisplayName(this.value == null ? "null" : this.value.size() + " selected:");
        if (this.value != null) {
            for (T t : this.value) {
                builder.addLore(t.toString());
            }
        }
        this.add(new Label(0, builder));
        for (int i = 0; i < Math.min(this.allowNull ? 51 : 52, this.values.length); ++i) {
            T t;
            t = this.values[i];
            boolean added = false;
            if (this.value != null) {
                added = this.value.contains(t);
            }
            this.add(new Button(i + 1, this.makeItem(this.materials[i]).setDisplayName(t.toString()).addLore("Left click to add").addLore("Right click to remove").addLore(added ? "Added" : "Not Added"), click -> {
                if (click == ClickType.LEFT) {
                    if (this.value == null) {
                        this.value = new HashSet();
                    }
                    this.value.add(t);
                    this.setFunc.accept(this.value);
                }
                if (click == ClickType.RIGHT) {
                    if (this.value == null) {
                        this.value = new HashSet();
                    }
                    this.value.remove(t);
                    this.setFunc.accept(this.value);
                }
                this.refresh();
            }));
        }
        if (this.allowNull) {
            this.add(new Button(this.values.length + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }

    private static int getSize(int count, boolean allowNull) {
        int actualCount = count + 2;
        if (allowNull) {
            ++actualCount;
        }
        if (actualCount > 54) {
            throw new IllegalArgumentException("MenuModifyEnumSet only supports up to 52 values! (including null)");
        }
        if (actualCount / 9 * 9 == actualCount) {
            return actualCount;
        }
        return actualCount / 9 * 9 + 9;
    }
}

