/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyEnchantmentMap
extends Menu {
    private HashMap<Enchantment, Integer> value;
    private final boolean allowNull;
    private final Consumer<HashMap<Enchantment, Integer>> setFunc;

    public MenuModifyEnchantmentMap(Menu parent, Plugin plugin, Player player, String name, boolean allowNull, HashMap<Enchantment, Integer> defaultValue, Consumer<HashMap<Enchantment, Integer>> setFunc) {
        super(parent, plugin, player, "Modify Enchantment Map (" + name + ")", MenuModifyEnchantmentMap.getSize(allowNull));
        this.value = defaultValue;
        this.allowNull = allowNull;
        this.refresh();
        this.setFunc = setFunc;
    }

    private void refresh() {
        this.components.clear();
        ItemBuilder builder = this.makeItem(Material.PAPER).setDisplayName(this.value == null ? "null" : this.value.size() + " enchantments:");
        if (this.value != null) {
            for (Enchantment e : this.value.keySet()) {
                builder.addLore(e.toString() + " " + this.value.get(e));
            }
        }
        this.add(new Label(0, builder));
        for (int i = 0; i < Math.min(this.allowNull ? 51 : 52, Enchantment.values().length); ++i) {
            Enchantment enchantment = Enchantment.values()[i];
            Integer level = this.value == null ? null : this.value.get(enchantment);
            this.add(new Button(i + 1, this.makeItem(Material.ENCHANTED_BOOK).enchant(enchantment, level == null ? 1 : level).setDisplayName(enchantment.toString()).addLore("Left click to increase enchantment level").addLore("Right click to decrease enchantment level").addLore("Current level: " + (level == null ? "null" : level)), click -> {
                if (click == ClickType.LEFT) {
                    if (this.value == null) {
                        this.value = new HashMap();
                    }
                    this.value.put(enchantment, this.value.containsKey(enchantment) ? this.value.get(enchantment) + 1 : 1);
                    this.setFunc.accept(this.value);
                }
                if (click == ClickType.RIGHT) {
                    if (this.value == null) {
                        this.value = new HashMap();
                    }
                    this.value.put(enchantment, this.value.containsKey(enchantment) ? this.value.get(enchantment) - 1 : 0);
                    if (this.value.get(enchantment) < 0) {
                        this.value.remove(enchantment);
                    }
                    this.setFunc.accept(this.value);
                }
                this.refresh();
            }));
        }
        if (this.allowNull) {
            this.add(new Button(Enchantment.values().length + 1, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                this.setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(this.parent);
        }));
        this.updateInventory();
    }

    private static int getSize(boolean allowNull) {
        int actualCount = Enchantment.values().length + 2;
        if (allowNull) {
            ++actualCount;
        }
        if (actualCount > 54) {
            throw new IllegalArgumentException("MenuModifyEnchantments only supports up to " + (allowNull ? 51 : 52) + " values!");
        }
        if (actualCount / 9 * 9 == actualCount) {
            return actualCount;
        }
        return actualCount / 9 * 9 + 9;
    }
}

