/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu.modify;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuModifyDouble
extends Menu {
    private Double value;
    private final Button display;

    public MenuModifyDouble(Menu parent, Plugin plugin, Player player, String name, double min, double max, boolean allowNull, Double defaultValue, Consumer<Double> setFunc) {
        this(parent, plugin, player, name, min, max, 0.1, allowNull, defaultValue, setFunc);
    }

    public MenuModifyDouble(Menu parent, Plugin plugin, Player player, String name, double min, double max, double majorIncrement, boolean allowNull, Double defaultValue, Consumer<Double> setFunc) {
        this(parent, plugin, player, name, min, max, majorIncrement, majorIncrement / 10.0, allowNull, defaultValue, setFunc);
    }

    public MenuModifyDouble(Menu parent, Plugin plugin, Player player, String name, double min, double max, double majorIncrement, double minorIncrement, boolean allowNull, Double defaultValue, Consumer<Double> setFunc) {
        super(parent, plugin, player, "Modify Double (" + name + ")", 9);
        this.value = defaultValue;
        this.display = this.add(new Button(0, this.makeItem(Material.PAPER).setDisplayName(Objects.toString(defaultValue)).addLore("Click to set value"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.openAnvilGUI(this.value == null ? "0" : this.value.toString(), "Edit " + name, (plyr, string) -> {
                string = string.trim();
                try {
                    this.value = Math.min(max, Math.max(min, Double.parseDouble(string)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                setFunc.accept(this.value);
                this.refresh();
            });
        }));
        this.add(new Button(2, this.makeItem(Material.RED_CONCRETE).setDisplayName("-" + majorIncrement), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            if (this.value == null) {
                this.value = 0.0;
            }
            this.value = Math.min(max, Math.max(min, this.value - majorIncrement));
            setFunc.accept(this.value);
            this.refresh();
        }));
        this.add(new Button(3, this.makeItem(Material.RED_TERRACOTTA).setDisplayName("-" + minorIncrement), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            if (this.value == null) {
                this.value = 0.0;
            }
            this.value = Math.min(max, Math.max(min, this.value - minorIncrement));
            setFunc.accept(this.value);
            this.refresh();
        }));
        if (allowNull) {
            this.add(new Button(4, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to NULL"), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = null;
                setFunc.accept(this.value);
                this.refresh();
            }));
        } else {
            this.add(new Button(4, this.makeItem(Material.BLACK_CONCRETE).setDisplayName("Set to " + Math.min(max, Math.max(min, 0.0))), click -> {
                if (click != ClickType.LEFT) {
                    return;
                }
                this.value = Math.min(max, Math.max(min, 0.0));
                setFunc.accept(this.value);
                this.refresh();
            }));
        }
        this.add(new Button(5, this.makeItem(Material.GREEN_TERRACOTTA).setDisplayName("+" + minorIncrement), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            if (this.value == null) {
                this.value = 0.0;
            }
            this.value = Math.min(max, Math.max(min, this.value + minorIncrement));
            setFunc.accept(this.value);
            this.refresh();
        }));
        this.add(new Button(6, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("+" + majorIncrement), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            if (this.value == null) {
                this.value = 0.0;
            }
            this.value = Math.min(max, Math.max(min, this.value + majorIncrement));
            setFunc.accept(this.value);
            this.refresh();
        }));
        this.add(new Button(8, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click != ClickType.LEFT) {
                return;
            }
            this.open(parent);
        }));
    }

    public void refresh() {
        this.display.label = this.makeItem(Material.PAPER).setDisplayName(Objects.toString(this.value)).addLore("Click to set value").build();
        this.updateInventory();
    }
}

