/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.select.MenuSelectMaterialSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuTreesConfiguration
extends Menu {
    private final int page;
    private final int TREES_PER_PAGE = 45;

    public MenuTreesConfiguration(Menu parent, Plugin plugin, Player player) {
        this(parent, plugin, player, 0);
    }

    public MenuTreesConfiguration(Menu parent, Plugin plugin, Player player, int page) {
        super(parent, plugin, player, "Trees Configuration", 54);
        this.page = page;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        int pageMin = this.page * 45;
        int pageMax = (this.page + 1) * 45;
        this.components.clear();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
        this.add(new Button(this.size - 6, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("New tree"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuSelectMaterialSet(this, this.plugin, this.player, "New Tree Trunk", false, "block", new HashSet<Material>(), mat -> mat.isBlock(), (menu, trunk) -> {
                    if (trunk.isEmpty()) {
                        return;
                    }
                    menu.open(new MenuSelectMaterialSet(this, this.plugin, this.player, "New Tree Leaves", false, "block", new HashSet<Material>(), mat -> mat.isBlock(), (menu2, leaves) -> {
                        if (leaves.isEmpty()) {
                            return;
                        }
                        Tree tree = new Tree(new ArrayList<Material>((Collection<Material>)trunk), new ArrayList<Material>((Collection<Material>)leaves));
                        TreeFeller.trees.add(tree);
                        menu2.open(new MenuTreeConfiguration(this, this.plugin, this.player, tree));
                    }));
                }));
            }
        }));
        this.add(new Button(this.size - 4, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("Detect tree").addLore("Creates a new tree based on a template tree in the world").addLore("Right click a tree to select it.").addLore("Make sure the tree is not touching any build or other trees").addLore("There may be a lag spike when detecting a tree"), click -> {
            if (click == ClickType.LEFT) {
                this.close();
                TreeFeller.detectingTrees.put(this.player, this);
                this.player.sendMessage("Right click a tree to select it");
            }
        }));
        if (this.page > 0) {
            this.add(new Button(this.size - 9, this.makeItem(Material.PAPER).setDisplayName("Previous Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuTreesConfiguration(this.parent, this.plugin, this.player, this.page - 1));
                }
            }));
        }
        if (pageMax < TreeFeller.trees.size()) {
            this.add(new Button(this.size - 2, this.makeItem(Material.PAPER).setDisplayName("Next Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuTreesConfiguration(this.parent, this.plugin, this.player, this.page + 1));
                }
            }));
        }
        int index = 0;
        int offset = 0;
        for (int i = 0; i < Math.min(pageMax, TreeFeller.trees.size() - offset); ++i) {
            Tree t = TreeFeller.trees.get(i + offset);
            int idx = i + offset;
            if (i < pageMin) continue;
            this.add(new Button(index, this.makeItem(t.getDisplayMaterial()).setDisplayName("Tree #" + i).addLore("Shift-left click to move left").addLore("Shift-right click to move right"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuTreeConfiguration(this, this.plugin, this.player, t));
                }
                if (click == ClickType.SHIFT_LEFT) {
                    if (idx == 0) {
                        return;
                    }
                    TreeFeller.trees.remove(t);
                    TreeFeller.trees.add(idx - 1, t);
                    this.refresh();
                }
                if (click == ClickType.SHIFT_RIGHT) {
                    if (idx == TreeFeller.trees.size() - 1) {
                        return;
                    }
                    TreeFeller.trees.remove(t);
                    TreeFeller.trees.add(idx + 1, t);
                    this.refresh();
                }
            }));
            ++index;
        }
        this.updateInventory();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
    }
}

