/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyMaterialSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuTreeConfiguration
extends Menu {
    private final Tree tree;
    private final int page;
    private final int OPTIONS_PER_PAGE = 45;

    public MenuTreeConfiguration(Menu parent, Plugin plugin, Player player, Tree tree) {
        this(parent, plugin, player, tree, 0);
    }

    public MenuTreeConfiguration(Menu parent, Plugin plugin, Player player, Tree tree, int page) {
        super(parent, plugin, player, "Tree Configuration", 54);
        this.tree = tree;
        this.page = page;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        int pageMin = this.page * 45;
        int pageMax = (this.page + 1) * 45;
        this.components.clear();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back").addLore("Shift-right click to delete tree"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
            if (click == ClickType.SHIFT_RIGHT) {
                TreeFeller.trees.remove(this.tree);
                this.open(this.parent);
            }
        }));
        this.add(new Button(this.size - 6, this.makeItem(this.tree.trunk.isEmpty() ? Material.OAK_LOG : this.tree.trunk.get(0)).setDisplayName("Click to modify Trunk"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuModifyMaterialSet(this, this.plugin, this.player, "Modify Tree Trunk", false, "block", new HashSet<Material>(this.tree.trunk), material -> material.isBlock(), value -> {
                    this.tree.trunk.clear();
                    this.tree.trunk.addAll((Collection<Material>)value);
                }));
            }
        }));
        this.add(new Button(this.size - 4, this.makeItem(this.tree.leaves.isEmpty() ? Material.OAK_LEAVES : this.tree.leaves.get(0)).setDisplayName("Click to modify Leaves"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuModifyMaterialSet(this, this.plugin, this.player, "Modify Tree Leaves", false, "block", new HashSet<Material>(this.tree.leaves), material -> material.isBlock(), value -> {
                    this.tree.leaves.clear();
                    this.tree.leaves.addAll((Collection<Material>)value);
                }));
            }
        }));
        if (this.page > 0) {
            this.add(new Button(this.size - 9, this.makeItem(Material.PAPER).setDisplayName("Previous Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuTreeConfiguration(this.parent, this.plugin, this.player, this.tree, this.page - 1));
                }
            }));
        }
        if (pageMax < Option.options.size()) {
            this.add(new Button(this.size - 2, this.makeItem(Material.PAPER).setDisplayName("Next Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuTreeConfiguration(this.parent, this.plugin, this.player, this.tree, this.page + 1));
                }
            }));
        }
        int index = 0;
        int offset = 0;
        for (int i = 0; i < Math.min(pageMax, Option.options.size() - offset); ++i) {
            Option o = Option.options.get(i + offset);
            if (!o.tree) {
                --i;
                ++offset;
                continue;
            }
            if (i < pageMin) continue;
            this.add(new Button(index, o.getConfigurationDisplayItem(this.tree).setDisplayName(o.getFriendlyName()).addLore(ChatColor.GRAY + this.shorten(Objects.toString(o.getValue(this.tree)), 42)).addLore(this.shorten(o.getDescription(true), 42)), click -> {
                if (click == ClickType.LEFT) {
                    o.openTreeModifyMenu(this, this.tree);
                }
            }));
            ++index;
        }
        this.updateInventory();
    }

    private ArrayList<String> shorten(ArrayList<String> description, int chars) {
        ArrayList<String> output = new ArrayList<String>();
        for (String s : description) {
            String[] split = s.split(" ");
            String str = "";
            for (int i = 0; i < split.length; ++i) {
                if ((str = str + " " + split[i]).length() <= chars) continue;
                output.add(str.trim());
                str = "";
            }
            if (str.trim().isEmpty()) continue;
            output.add(str.trim());
        }
        return output;
    }

    private String shorten(String s, int chars) {
        if (s.length() <= chars) {
            return s;
        }
        return s.substring(0, chars - 3) + "...";
    }
}

