/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.select.MenuSelectMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuToolsConfiguration
extends Menu {
    private final int page;
    private final int TOOLS_PER_PAGE = 45;

    public MenuToolsConfiguration(Menu parent, Plugin plugin, Player player) {
        this(parent, plugin, player, 0);
    }

    public MenuToolsConfiguration(Menu parent, Plugin plugin, Player player, int page) {
        super(parent, plugin, player, "Tools Configuration", 54);
        this.page = page;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        int pageMin = this.page * 45;
        int pageMax = (this.page + 1) * 45;
        this.components.clear();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
        this.add(new Button(this.size - 5, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("New tool"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuSelectMaterial(this, this.plugin, this.player, "New Tool", false, "item", null, mat -> mat.isItem(), (menu, value) -> {
                    if (value == null) {
                        return;
                    }
                    Tool tool = new Tool((Material)value);
                    TreeFeller.tools.add(tool);
                    menu.open(new MenuToolConfiguration(this, this.plugin, this.player, tool));
                }));
            }
        }));
        if (this.page > 0) {
            this.add(new Button(this.size - 9, this.makeItem(Material.PAPER).setDisplayName("Previous Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuToolsConfiguration(this.parent, this.plugin, this.player, this.page - 1));
                }
            }));
        }
        if (pageMax < TreeFeller.tools.size()) {
            this.add(new Button(this.size - 2, this.makeItem(Material.PAPER).setDisplayName("Next Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuToolsConfiguration(this.parent, this.plugin, this.player, this.page + 1));
                }
            }));
        }
        int index = 0;
        int offset = 0;
        for (int i = 0; i < Math.min(pageMax, TreeFeller.tools.size() - offset); ++i) {
            Tool t = TreeFeller.tools.get(i + offset);
            int idx = i + offset;
            if (i < pageMin) continue;
            ItemBuilder builder = this.makeItem(t.material);
            if (Option.REQUIRED_NAME.toolValues.containsKey(t)) {
                builder.setDisplayName(Option.REQUIRED_NAME.getValue(t));
            }
            builder.addLore("Shift-left click to move left");
            builder.addLore("Shift-right click to move right");
            if (Option.REQUIRED_LORE.toolValues.containsKey(t)) {
                for (String lore : Option.REQUIRED_LORE.getValue(t)) {
                    builder.addLore(lore);
                }
            }
            this.add(new Button(index, builder, click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuToolConfiguration(this, this.plugin, this.player, t));
                }
                if (click == ClickType.SHIFT_LEFT) {
                    if (idx == 0) {
                        return;
                    }
                    TreeFeller.tools.remove(t);
                    TreeFeller.tools.add(idx - 1, t);
                    this.refresh();
                }
                if (click == ClickType.SHIFT_RIGHT) {
                    if (idx == TreeFeller.tools.size() - 1) {
                        return;
                    }
                    TreeFeller.tools.remove(t);
                    TreeFeller.tools.add(idx + 1, t);
                    this.refresh();
                }
            }));
            ++index;
        }
        this.updateInventory();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
    }
}

