/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyMaterial;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuToolConfiguration
extends Menu {
    private final Tool tool;
    private final int page;
    private final int OPTIONS_PER_PAGE = 45;

    public MenuToolConfiguration(Menu parent, Plugin plugin, Player player, Tool tool) {
        this(parent, plugin, player, tool, 0);
    }

    public MenuToolConfiguration(Menu parent, Plugin plugin, Player player, Tool tool, int page) {
        super(parent, plugin, player, "Tool Configuration", 54);
        this.tool = tool;
        this.page = page;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        int pageMin = this.page * 45;
        int pageMax = (this.page + 1) * 45;
        this.components.clear();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back").addLore("Shift-right click to delete tool"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
            if (click == ClickType.SHIFT_RIGHT) {
                TreeFeller.tools.remove(this.tool);
                this.open(this.parent);
            }
        }));
        this.add(new Button(this.size - 5, this.makeItem(this.tool.material).addLore("Click to modify material"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuModifyMaterial(this, this.plugin, this.player, "Modify Tool Material", false, "item", this.tool.material, material -> material.isItem(), value -> {
                    this.tool.material = value;
                }));
            }
        }));
        if (this.page > 0) {
            this.add(new Button(this.size - 9, this.makeItem(Material.PAPER).setDisplayName("Previous Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuToolConfiguration(this.parent, this.plugin, this.player, this.tool, this.page - 1));
                }
            }));
        }
        if (pageMax < Option.options.size()) {
            this.add(new Button(this.size - 2, this.makeItem(Material.PAPER).setDisplayName("Next Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuToolConfiguration(this.parent, this.plugin, this.player, this.tool, this.page + 1));
                }
            }));
        }
        int index = 0;
        int offset = 0;
        for (int i = 0; i < Math.min(pageMax, Option.options.size() - offset); ++i) {
            Option o = Option.options.get(i + offset);
            if (!o.tool) {
                --i;
                ++offset;
                continue;
            }
            if (i < pageMin) continue;
            this.add(new Button(index, o.getConfigurationDisplayItem(this.tool).setDisplayName(o.getFriendlyName()).addLore(ChatColor.GRAY + this.shorten(Objects.toString(o.getValue(this.tool)), 42)).addLore(this.shorten(o.getDescription(true), 42)), click -> {
                if (click == ClickType.LEFT) {
                    o.openToolModifyMenu(this, this.tool);
                }
            }));
            ++index;
        }
        this.updateInventory();
    }

    private ArrayList<String> shorten(ArrayList<String> description, int chars) {
        ArrayList<String> output = new ArrayList<String>();
        for (String s : description) {
            String[] split = s.split(" ");
            String str = "";
            for (int i = 0; i < split.length; ++i) {
                if ((str = str + " " + split[i]).length() <= chars) continue;
                output.add(str.trim());
                str = "";
            }
            if (str.trim().isEmpty()) continue;
            output.add(str.trim());
        }
        return output;
    }

    private String shorten(String s, int chars) {
        if (s.length() <= chars) {
            return s;
        }
        return s.substring(0, chars - 3) + "...";
    }
}

