/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Message;
import com.thizthizzydizzy.treefeller.menu.MenuMessageConfiguration;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuMessagesConfiguration
extends Menu {
    private final int page;
    private final int TOOLS_PER_PAGE = 45;

    public MenuMessagesConfiguration(Menu parent, Plugin plugin, Player player) {
        this(parent, plugin, player, 0);
    }

    public MenuMessagesConfiguration(Menu parent, Plugin plugin, Player player, int page) {
        super(parent, plugin, player, "Messages Configuration", 54);
        this.page = page;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        int pageMin = this.page * 45;
        int pageMax = (this.page + 1) * 45;
        this.components.clear();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
        if (this.page > 0) {
            this.add(new Button(this.size - 9, this.makeItem(Material.PAPER).setDisplayName("Previous Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuMessagesConfiguration(this.parent, this.plugin, this.player, this.page - 1));
                }
            }));
        }
        if (pageMax < Message.messages.size()) {
            this.add(new Button(this.size - 2, this.makeItem(Material.PAPER).setDisplayName("Next Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuMessagesConfiguration(this.parent, this.plugin, this.player, this.page + 1));
                }
            }));
        }
        int index = 0;
        int offset = 0;
        for (int i = 0; i < Math.min(pageMax, Message.messages.size() - offset); ++i) {
            Message message = Message.messages.get(i + offset);
            if (i < pageMin) continue;
            this.add(new Button(index, new ItemBuilder(message.icon).setDisplayName(message.name), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuMessageConfiguration(this, this.plugin, this.player, message));
                }
            }));
            ++index;
        }
        this.updateInventory();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
    }
}

