/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Message;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuMessageConfiguration
extends Menu {
    private final Message message;

    public MenuMessageConfiguration(Menu parent, Plugin plugin, Player player, Message message) {
        super(parent, plugin, player, "Message Configuration: " + message.name, 9);
        this.message = message;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        this.components.clear();
        this.add(new Label(0, new ItemBuilder(this.message.icon).setDisplayName(this.message.name)));
        this.add(new Button(3, this.makeItem(Material.DEBUG_STICK).setDisplayName("Debug").addLore(this.message.debug == null ? "null" : this.message.debug), click -> {
            if (click == ClickType.LEFT) {
                this.openAnvilGUI(this.message.debug == null ? "null" : this.message.debug, "Set Debug: " + this.message.name, (player, str) -> {
                    this.message.debug = str;
                });
            }
        }));
        this.add(new Button(4, this.makeItem(Material.PAPER).setDisplayName("Chat").addLore(this.message.chat == null ? "null" : this.message.chat), click -> {
            if (click == ClickType.LEFT) {
                this.openAnvilGUI(this.message.chat == null ? "null" : this.message.chat, "Set Chat: " + this.message.name, (player, str) -> {
                    this.message.chat = str.equalsIgnoreCase("null") ? null : str;
                });
            }
        }));
        this.add(new Button(5, this.makeItem(Material.IRON_SWORD).setDisplayName("Actionbar").addLore(this.message.actionbar == null ? "null" : this.message.actionbar), click -> {
            if (click == ClickType.LEFT) {
                this.openAnvilGUI(this.message.actionbar == null ? "null" : this.message.actionbar, "Set Actionbar: " + this.message.name, (player, str) -> {
                    this.message.actionbar = str.equalsIgnoreCase("null") ? null : str;
                });
            }
        }));
        this.add(new Button(8, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
        this.updateInventory();
    }
}

