/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Effect;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.MenuEffectConfiguration;
import com.thizthizzydizzy.treefeller.menu.select.MenuSelectEnum;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class MenuEffectsConfiguration
extends Menu {
    private final int page;
    private final int EFFECTS_PER_PAGE = 45;

    public MenuEffectsConfiguration(Menu parent, Plugin plugin, Player player) {
        this(parent, plugin, player, 0);
    }

    public MenuEffectsConfiguration(Menu parent, Plugin plugin, Player player, int page) {
        super(parent, plugin, player, "Effects Configuration", 54);
        this.page = page;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        int pageMin = this.page * 45;
        int pageMax = (this.page + 1) * 45;
        this.components.clear();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
        this.add(new Button(this.size - 5, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("New effect"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuSelectEnum<Effect.EffectType>((Menu)this, this.plugin, this.player, "New Effect", "EffectType", false, null, Effect.EffectType.values(), (menu, value) -> {
                    Effect effect = Effect.newEffect(value);
                    TreeFeller.effects.add(effect);
                    menu.open(new MenuEffectConfiguration(this, this.plugin, this.player, effect));
                }){

                    @Override
                    public Material getItem(Effect.EffectType value) {
                        return value.getItem();
                    }
                });
            }
        }));
        if (this.page > 0) {
            this.add(new Button(this.size - 9, this.makeItem(Material.PAPER).setDisplayName("Previous Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuEffectsConfiguration(this.parent, this.plugin, this.player, this.page - 1));
                }
            }));
        }
        if (pageMax < TreeFeller.effects.size()) {
            this.add(new Button(this.size - 2, this.makeItem(Material.PAPER).setDisplayName("Next Page"), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuEffectsConfiguration(this.parent, this.plugin, this.player, this.page + 1));
                }
            }));
        }
        int index = 0;
        int offset = 0;
        for (int i = 0; i < Math.min(pageMax, TreeFeller.effects.size() - offset); ++i) {
            Effect effect = TreeFeller.effects.get(i + offset);
            if (i < pageMin) continue;
            this.add(new Button(index, this.makeItem(effect.type.getItem()).setDisplayName(effect.name), click -> {
                if (click == ClickType.LEFT) {
                    this.open(new MenuEffectConfiguration(this, this.plugin, this.player, effect));
                }
            }));
            ++index;
        }
        this.updateInventory();
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
        }));
    }
}

