/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.Effect;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyBoolean;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyDouble;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyEnum;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyFloat;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyInteger;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyMaterial;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringList;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuEffectConfiguration
extends Menu {
    private final Effect effect;

    public MenuEffectConfiguration(Menu parent, Plugin plugin, Player player, Effect effect) {
        super(parent, plugin, player, "Effect Configuration: " + effect.name, 18);
        this.effect = effect;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        this.components.clear();
        this.add(new Button(0, new ItemBuilder(Material.PAPER).setDisplayName("Name").addLore(this.effect.name), click -> {
            if (click == ClickType.LEFT) {
                this.openAnvilGUI(this.effect.name, "Modify Effect Name", (player, str) -> {
                    this.effect.name = str;
                });
            }
        }));
        this.add(new Button(1, new ItemBuilder(this.effect.location.getItem()).setDisplayName("Location").addLore(this.effect.location.toString()), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuModifyEnum<Effect.EffectLocation>((Menu)this, this.plugin, this.player, this.effect.name, "EffectLocation", false, this.effect.location, Effect.EffectLocation.values(), value -> {
                    this.effect.location = value;
                }){

                    @Override
                    public Material getItem(Effect.EffectLocation value) {
                        return value.getItem();
                    }
                });
            }
        }));
        this.add(new Button(2, new ItemBuilder(Material.BELL).setDisplayName("Chance").addLore(this.effect.chance + ""), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, 0.0, 1.0, false, this.effect.chance, value -> {
                    this.effect.chance = value;
                }));
            }
        }));
        switch (this.effect.type) {
            case EXPLOSION: {
                this.add(new Button(3, new ItemBuilder(Material.TNT).setDisplayName("Power").addLore(this.effect.power + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyFloat(this, this.plugin, this.player, this.effect.name, 0.0f, Float.MAX_VALUE, false, Float.valueOf(this.effect.power), value -> {
                            this.effect.power = value.floatValue();
                        }));
                    }
                }));
                this.add(new Button(4, new ItemBuilder(Material.FIRE_CHARGE).setDisplayName("Fire").addLore(this.effect.fire + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyBoolean(this, this.plugin, this.player, this.effect.name, false, this.effect.fire, value -> {
                            this.effect.fire = value;
                        }));
                    }
                }));
                break;
            }
            case SOUND: {
                this.add(new Button(3, new ItemBuilder(Material.NOTE_BLOCK).setDisplayName("Sound").addLore(this.effect.sound), click -> {
                    if (click == ClickType.LEFT) {
                        this.openAnvilGUI(this.effect.sound, "Modify Effect Sound: " + this.effect.name, (player, str) -> {
                            this.effect.sound = str;
                        });
                    }
                }));
                this.add(new Button(4, new ItemBuilder(Material.NOTE_BLOCK).setDisplayName("Volume").addLore(this.effect.volume + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyFloat(this, this.plugin, this.player, this.effect.name, 0.0f, Float.MAX_VALUE, false, Float.valueOf(this.effect.volume), value -> {
                            this.effect.volume = value.floatValue();
                        }));
                    }
                }));
                this.add(new Button(5, new ItemBuilder(Material.NOTE_BLOCK).setDisplayName("Pitch").addLore(this.effect.pitch + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyFloat(this, this.plugin, this.player, this.effect.name, 0.5f, 2.0f, false, Float.valueOf(this.effect.pitch), value -> {
                            this.effect.pitch = value.floatValue();
                        }));
                    }
                }));
                break;
            }
            case PARTICLE: {
                this.add(new Button(3, new ItemBuilder(Material.FIREWORK_STAR).setDisplayName("Particle").addLore(this.effect.particle.toString()), click -> {
                    if (click == ClickType.LEFT) {
                        this.openAnvilGUI(this.effect.particle.name(), "Modify Effect Particle: " + this.effect.name, (player, str) -> {
                            try {
                                Particle p = TreeFeller.getParticle(str);
                                if (p != null) {
                                    this.effect.particle = p;
                                    this.effect.extra = null;
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        });
                    }
                }));
                this.add(new Button(4, new ItemBuilder(Material.RED_CONCRETE).setDisplayName("x").addLore(this.effect.x + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, -1.7976931348623157E308, Double.MAX_VALUE, false, this.effect.x, value -> {
                            this.effect.x = value;
                        }));
                    }
                }));
                this.add(new Button(5, new ItemBuilder(Material.GREEN_CONCRETE).setDisplayName("y").addLore(this.effect.y + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, -1.7976931348623157E308, Double.MAX_VALUE, false, this.effect.y, value -> {
                            this.effect.y = value;
                        }));
                    }
                }));
                this.add(new Button(6, new ItemBuilder(Material.BLUE_CONCRETE).setDisplayName("z").addLore(this.effect.z + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, -1.7976931348623157E308, Double.MAX_VALUE, false, this.effect.z, value -> {
                            this.effect.z = value;
                        }));
                    }
                }));
                this.add(new Button(7, new ItemBuilder(Material.RED_CONCRETE).setDisplayName("dx").addLore(this.effect.dx + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, -1.7976931348623157E308, Double.MAX_VALUE, false, this.effect.dx, value -> {
                            this.effect.dx = value;
                        }));
                    }
                }));
                this.add(new Button(8, new ItemBuilder(Material.GREEN_CONCRETE).setDisplayName("dy").addLore(this.effect.dy + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, -1.7976931348623157E308, Double.MAX_VALUE, false, this.effect.dy, value -> {
                            this.effect.dy = value;
                        }));
                    }
                }));
                this.add(new Button(9, new ItemBuilder(Material.BLUE_CONCRETE).setDisplayName("dz").addLore(this.effect.dz + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, -1.7976931348623157E308, Double.MAX_VALUE, false, this.effect.dz, value -> {
                            this.effect.dz = value;
                        }));
                    }
                }));
                this.add(new Button(10, new ItemBuilder(Material.BLUE_CONCRETE).setDisplayName("Speed").addLore(this.effect.speed + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyDouble(this, this.plugin, this.player, this.effect.name, 0.0, Double.MAX_VALUE, false, this.effect.speed, value -> {
                            this.effect.speed = value;
                        }));
                    }
                }));
                this.add(new Button(11, new ItemBuilder(Material.BLUE_CONCRETE).setDisplayName("Count").addLore(this.effect.count + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyInteger(this, this.plugin, this.player, this.effect.name, 0, Integer.MAX_VALUE, false, this.effect.count, value -> {
                            this.effect.count = value;
                        }));
                    }
                }));
                switch (this.effect.particle) {
                    case REDSTONE: {
                        this.add(new Button(12, new ItemBuilder(Material.RED_DYE).setDisplayName("Red").addLore(this.effect.extra == null ? "null" : ((Particle.DustOptions)this.effect.extra).getColor().getRed() + ""), click -> {
                            if (click == ClickType.LEFT) {
                                this.open(new MenuModifyInteger(this, this.plugin, this.player, this.effect.name, 0, 255, false, this.effect.extra == null ? 0 : ((Particle.DustOptions)this.effect.extra).getColor().getRed(), value -> {
                                    int g = 0;
                                    int b = 0;
                                    float size = 1.0f;
                                    if (this.effect.extra != null) {
                                        Particle.DustOptions extra = (Particle.DustOptions)this.effect.extra;
                                        g = extra.getColor().getGreen();
                                        b = extra.getColor().getBlue();
                                        size = extra.getSize();
                                    }
                                    this.effect.extra = new Particle.DustOptions(Color.fromRGB((int)value, (int)g, (int)b), size);
                                }));
                            }
                        }));
                        this.add(new Button(13, new ItemBuilder(Material.GREEN_DYE).setDisplayName("Green").addLore(this.effect.extra == null ? "null" : ((Particle.DustOptions)this.effect.extra).getColor().getGreen() + ""), click -> {
                            if (click == ClickType.LEFT) {
                                this.open(new MenuModifyInteger(this, this.plugin, this.player, this.effect.name, 0, 255, false, this.effect.extra == null ? 0 : ((Particle.DustOptions)this.effect.extra).getColor().getGreen(), value -> {
                                    int r = 0;
                                    int b = 0;
                                    float size = 1.0f;
                                    if (this.effect.extra != null) {
                                        Particle.DustOptions extra = (Particle.DustOptions)this.effect.extra;
                                        r = extra.getColor().getRed();
                                        b = extra.getColor().getBlue();
                                        size = extra.getSize();
                                    }
                                    this.effect.extra = new Particle.DustOptions(Color.fromRGB((int)r, (int)value, (int)b), size);
                                }));
                            }
                        }));
                        this.add(new Button(14, new ItemBuilder(Material.BLUE_DYE).setDisplayName("Blue").addLore(this.effect.extra == null ? "null" : ((Particle.DustOptions)this.effect.extra).getColor().getBlue() + ""), click -> {
                            if (click == ClickType.LEFT) {
                                this.open(new MenuModifyInteger(this, this.plugin, this.player, this.effect.name, 0, 255, false, this.effect.extra == null ? 0 : ((Particle.DustOptions)this.effect.extra).getColor().getBlue(), value -> {
                                    int r = 0;
                                    int g = 0;
                                    float size = 1.0f;
                                    if (this.effect.extra != null) {
                                        Particle.DustOptions extra = (Particle.DustOptions)this.effect.extra;
                                        r = extra.getColor().getRed();
                                        g = extra.getColor().getGreen();
                                        size = extra.getSize();
                                    }
                                    this.effect.extra = new Particle.DustOptions(Color.fromRGB((int)r, (int)g, (int)value), size);
                                }));
                            }
                        }));
                        this.add(new Button(15, new ItemBuilder(Material.PISTON).setDisplayName("Size").addLore(this.effect.extra == null ? "null" : ((Particle.DustOptions)this.effect.extra).getSize() + ""), click -> {
                            if (click == ClickType.LEFT) {
                                this.open(new MenuModifyFloat(this, this.plugin, this.player, this.effect.name, 0.0f, Float.MAX_VALUE, false, Float.valueOf(this.effect.extra == null ? 0.0f : ((Particle.DustOptions)this.effect.extra).getSize()), value -> {
                                    int r = 0;
                                    int g = 0;
                                    int b = 0;
                                    if (this.effect.extra != null) {
                                        Particle.DustOptions extra = (Particle.DustOptions)this.effect.extra;
                                        r = extra.getColor().getRed();
                                        g = extra.getColor().getGreen();
                                        b = extra.getColor().getBlue();
                                    }
                                    this.effect.extra = new Particle.DustOptions(Color.fromRGB((int)r, (int)g, (int)b), value.floatValue());
                                }));
                            }
                        }));
                        break;
                    }
                    case ITEM_CRACK: {
                        this.add(new Button(12, new ItemBuilder(Material.IRON_PICKAXE).setDisplayName("Item").addLore(this.effect.extra == null ? "null" : ((ItemStack)this.effect.extra).getType().toString()), click -> {
                            if (click == ClickType.LEFT) {
                                this.open(new MenuModifyMaterial(this, this.plugin, this.player, this.effect.name, false, "item", this.effect.extra == null ? Material.IRON_PICKAXE : ((ItemStack)this.effect.extra).getType(), mat -> mat.isItem(), value -> {
                                    this.effect.extra = new ItemStack(value);
                                }));
                            }
                        }));
                        break;
                    }
                    case BLOCK_CRACK: 
                    case BLOCK_DUST: 
                    case FALLING_DUST: {
                        this.add(new Button(12, new ItemBuilder(Material.IRON_PICKAXE).setDisplayName("Block").addLore(this.effect.extra == null ? "null" : ((BlockData)this.effect.extra).getMaterial().toString()), click -> {
                            if (click == ClickType.LEFT) {
                                this.open(new MenuModifyMaterial(this, this.plugin, this.player, this.effect.name, false, "block", this.effect.extra == null ? Material.STONE : ((BlockData)this.effect.extra).getMaterial(), mat -> mat.isBlock(), value -> {
                                    this.effect.extra = Bukkit.createBlockData((Material)value);
                                }));
                            }
                        }));
                    }
                }
                break;
            }
            case MARKER: {
                this.add(new Button(3, new ItemBuilder(Material.ARMOR_STAND).setDisplayName("Permanent").addLore(this.effect.permanent + ""), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyBoolean(this, this.plugin, this.player, this.effect.name, false, this.effect.permanent, value -> {
                            this.effect.permanent = value;
                        }));
                    }
                }));
                this.add(new Button(4, new ItemBuilder(Material.PAPER).setDisplayName("Tags").addLore(Arrays.toString(this.effect.tags)), click -> {
                    if (click == ClickType.LEFT) {
                        this.open(new MenuModifyStringList(this, this.plugin, this.player, this.effect.name, false, new ArrayList<String>(Arrays.asList(this.effect.tags)), value -> {
                            this.effect.tags = value.toArray(new String[value.size()]);
                        }));
                    }
                }));
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not build GUI for EffectType: " + (Object)((Object)this.effect.type) + "! This is a bug!");
            }
        }
        this.add(new Button(this.size - 1, this.makeItem(Material.BARRIER).setDisplayName("Back").addLore("Shift-right click to delete effect"), click -> {
            if (click == ClickType.LEFT) {
                this.open(this.parent);
            }
            if (click == ClickType.SHIFT_RIGHT) {
                TreeFeller.effects.remove(this.effect);
                if (Option.EFFECTS.globalValue != null) {
                    ((ArrayList)Option.EFFECTS.globalValue).remove(this.effect);
                }
                for (Tool tool : TreeFeller.tools) {
                    if (Option.EFFECTS.getValue(tool) == null) continue;
                    Option.EFFECTS.getValue(tool).remove(this.effect);
                }
                for (Tree tree : TreeFeller.trees) {
                    if (Option.EFFECTS.getValue(tree) == null) continue;
                    Option.EFFECTS.getValue(tree).remove(this.effect);
                }
                this.open(this.parent);
            }
        }));
        this.updateInventory();
    }
}

