/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.menu;

import com.thizthizzydizzy.simplegui.Button;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.simplegui.Label;
import com.thizthizzydizzy.simplegui.Menu;
import com.thizthizzydizzy.treefeller.ConfigGenerator;
import com.thizthizzydizzy.treefeller.Message;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.menu.MenuEffectsConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuMessagesConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolsConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreesConfiguration;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.plugin.Plugin;

public class MenuConfiguration
extends Menu {
    private final TreeFeller treefeller;

    public MenuConfiguration(Menu parent, TreeFeller plugin, Player player) {
        super(parent, (Plugin)plugin, player, "TreeFeller Configuration", 54);
        this.treefeller = plugin;
        this.refresh();
    }

    @Override
    public void onOpen() {
        this.refresh();
    }

    private void refresh() {
        this.components.clear();
        for (int i = 0; i < this.size; ++i) {
            String additional = "";
            if (i < this.size - 18) {
                additional = " below";
            }
            if (i >= this.size - 9) {
                additional = " above";
            }
            this.add(new Label(i, this.makeItem(Material.RED_STAINED_GLASS_PANE).setDisplayName(ChatColor.DARK_RED + "WARNING").addLore("All changes made are applied immediately!").addLore("To revert changes, run /trefeller reload").addLore("To save changes, click the save button" + additional)));
        }
        this.add(new Button(11, this.makeItem(Material.GRASS_BLOCK).setDisplayName("Global"), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuGlobalConfiguration(this, this.plugin, this.player));
            }
        }));
        this.add(new Button(13, this.makeItem(Material.IRON_AXE).setDisplayName("Tools").addFlag(ItemFlag.HIDE_ATTRIBUTES).setCount(Math.max(1, TreeFeller.tools.size())), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuToolsConfiguration(this, this.plugin, this.player));
            }
        }));
        this.add(new Button(15, this.makeItem(Material.OAK_SAPLING).setDisplayName("Trees").setCount(TreeFeller.trees.size()), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuTreesConfiguration(this, this.plugin, this.player));
            }
        }));
        this.add(new Button(21, this.makeItem(Material.POTION).setDisplayName("Effects").setCount(TreeFeller.effects.size()).addFlag(ItemFlag.HIDE_POTION_EFFECTS), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuEffectsConfiguration(this, this.plugin, this.player));
            }
        }));
        this.add(new Button(23, this.makeItem(Material.PAPER).setDisplayName("Messages").setCount(Message.messages.size()), click -> {
            if (click == ClickType.LEFT) {
                this.open(new MenuMessagesConfiguration(this, this.plugin, this.player));
            }
        }));
        this.add(new Button(this.size - 14, this.makeItem(Material.GREEN_CONCRETE).setDisplayName("Save Configuration").addLore("Shift-left click to save.").addLore("This will overwrite the config.yml file!"), click -> {
            if (click == ClickType.SHIFT_LEFT) {
                ConfigGenerator.generateConfiguration(this.treefeller);
            }
        }));
        ItemBuilder patrons = this.makeItem(Material.ORANGE_CONCRETE).setDisplayName("Thank you to my patrons:");
        for (String patron : this.treefeller.patrons) {
            patrons.addLore(patron);
        }
        this.add(new Label(this.size - 11, patrons));
    }
}

