/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.decoration;

import com.thizthizzydizzy.treefeller.decoration.DecorationDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class AdjacentColumnDecorationDetector
extends DecorationDetector {
    private final BlockFace[] directions;
    private final List<Material> materials;

    public AdjacentColumnDecorationDetector(String name, Material material, BlockFace ... directions) {
        this(name, new Material[]{material}, directions);
    }

    public AdjacentColumnDecorationDetector(String name, Material[] materials, BlockFace ... directions) {
        super(name, materials[0]);
        this.materials = Arrays.asList(materials);
        this.directions = directions;
    }

    @Override
    public void detect(Block baseBlock, ArrayList<Block> blocks) {
        for (BlockFace direction : this.directions) {
            Block up;
            Block block = baseBlock.getRelative(direction);
            if (!this.materials.contains(block.getType())) continue;
            while (this.materials.contains((up = block.getRelative(BlockFace.UP)).getType())) {
                block = up;
            }
            while (this.materials.contains(block.getType())) {
                blocks.add(block);
                block = block.getRelative(BlockFace.DOWN);
            }
        }
    }
}

