/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.compat;

import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.OptionBoolean;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class PluginCompatibility {
    public OptionBoolean enabled = new OptionBoolean("Compatibility " + this.getCompatibilityName(), true, false, false, this.defaultEnabled(), this.defaultEnabled()){

        @Override
        public String getDesc(boolean ingame) {
            return "Toggle compatibility with " + PluginCompatibility.this.getFriendlyName();
        }

        @Override
        public String getFriendlyName() {
            return "Compatibility: " + PluginCompatibility.this.getFriendlyName();
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(Boolean value) {
            return PluginCompatibility.this.getConfigurationDisplayItem();
        }
    };

    public void init(TreeFeller treeFeller) {
    }

    public String getCompatibilityName() {
        return this.getPluginName();
    }

    public abstract String getPluginName();

    public void removeBlock(Player player, Block block) {
    }

    public void breakBlock(Tree tree, Tool tool, Player player, ItemStack axe, Block block, List<Modifier> modifiers) {
    }

    @Deprecated
    public void addBlock(Player player, Block block) {
    }

    public void addBlock(Player player, Block block, BlockState was) {
        this.addBlock(player, block);
    }

    public void dropItem(Player player, Item item) {
    }

    public boolean test(Player player, Block block) {
        return true;
    }

    public void fellTree(Block block, Player player, ItemStack axe, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks) {
    }

    public boolean defaultEnabled() {
        return true;
    }

    public Block test(Player player, Iterable<Block> blocks) {
        for (Block b : blocks) {
            if (this.test(player, b)) continue;
            return b;
        }
        return null;
    }

    public String getFriendlyName() {
        return this.getCompatibilityName();
    }

    public boolean isEnabled() {
        return this.enabled.isTrue();
    }

    public ItemBuilder getConfigurationDisplayItem() {
        return new ItemBuilder(Material.JIGSAW);
    }

    public void reload() {
    }

    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin(this.getPluginName());
    }

    public boolean isInstalled() {
        return this.getPlugin() != null && this.getPlugin().isEnabled();
    }
}

