/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.compat;

import com.thizthizzydizzy.treefeller.Cooldown;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.compat.InternalCompatibility;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderAPICompat
extends InternalCompatibility {
    private boolean initialized = false;

    @Override
    public String getPluginName() {
        return "PlaceholderAPI";
    }

    @Override
    public void init(TreeFeller treeFeller) {
        if (this.initialized) {
            return;
        }
        new TreeFellerExpansion(treeFeller).register();
        this.initialized = true;
    }

    public class TreeFellerExpansion
    extends PlaceholderExpansion {
        private final TreeFeller treefeller;

        private TreeFellerExpansion(TreeFeller treeFeller) {
            this.treefeller = treeFeller;
        }

        public String getIdentifier() {
            return "treefeller";
        }

        public String getAuthor() {
            return "ThizThizzyDizzy";
        }

        public String getVersion() {
            return "1.0.0";
        }

        public boolean persist() {
            return true;
        }

        public String onRequest(OfflinePlayer oplayer, String params) {
            Player player = null;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getUniqueId().equals(oplayer.getUniqueId())) continue;
                player = p;
            }
            if (params.equals("debug")) {
                return this.treefeller.debug ? "ON" : "OFF";
            }
            if (player != null && params.equals("toggled")) {
                return this.treefeller.isToggledOn(player) ? "ON" : "OFF";
            }
            if (oplayer != null && params.startsWith("cooldown")) {
                long ms;
                Cooldown cooldown = TreeFeller.cooldowns.get(oplayer.getUniqueId());
                if (params.startsWith("cooldown_global")) {
                    long ms2 = cooldown.getGlobal();
                    if (params.equals("cooldown_global_ms")) {
                        return ms2 + "";
                    }
                    if (params.equals("cooldown_global_t")) {
                        return ms2 / 50L + "";
                    }
                    if (params.equals("cooldown_global_s")) {
                        return ms2 / 1000L + "";
                    }
                }
                if (params.startsWith("cooldown_tree_")) {
                    int tree = Integer.parseInt(params.split("_")[2]);
                    ms = cooldown.get(TreeFeller.trees.get(tree));
                    if (params.equals("cooldown_tree_" + tree + "_ms")) {
                        return ms + "";
                    }
                    if (params.equals("cooldown_tree_" + tree + "_t")) {
                        return ms / 50L + "";
                    }
                    if (params.equals("cooldown_tree_" + tree + "_s")) {
                        return ms / 1000L + "";
                    }
                }
                if (params.startsWith("cooldown_tool_")) {
                    int tool = Integer.parseInt(params.split("_")[2]);
                    ms = cooldown.get(TreeFeller.trees.get(tool));
                    if (params.equals("cooldown_tool_" + tool + "_ms")) {
                        return ms + "";
                    }
                    if (params.equals("cooldown_tool_" + tool + "_t")) {
                        return ms / 50L + "";
                    }
                    if (params.equals("cooldown_tool_" + tool + "_s")) {
                        return ms / 1000L + "";
                    }
                }
                if (params.startsWith("cooldown_longest")) {
                    long ms3 = 0L;
                    for (long l : cooldown.getCooldowns()) {
                        if (l <= ms3) continue;
                        ms3 = l;
                    }
                    if (params.equals("cooldown_longest_ms")) {
                        return ms3 + "";
                    }
                    if (params.equals("cooldown_longest_t")) {
                        return ms3 / 50L + "";
                    }
                    if (params.equals("cooldown_longest_s")) {
                        return ms3 / 1000L + "";
                    }
                }
                if (params.startsWith("cooldown_shortest")) {
                    long ms4 = -1L;
                    for (long l : cooldown.getCooldowns()) {
                        if (ms4 != -1L && l >= ms4) continue;
                        ms4 = l;
                    }
                    if (params.equals("cooldown_shortest_ms")) {
                        return ms4 + "";
                    }
                    if (params.equals("cooldown_shortest_t")) {
                        return ms4 / 50L + "";
                    }
                    if (params.equals("cooldown_shortest_s")) {
                        return ms4 / 1000L + "";
                    }
                }
                if (params.equals("cooldown_count")) {
                    int count = 0;
                    for (long l : cooldown.getCooldowns()) {
                        if (l <= 0L) continue;
                        ++count;
                    }
                    if (params.equals("cooldown_count")) {
                        return count + "";
                    }
                }
            }
            return null;
        }
    }
}

