/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.compat;

import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.DebugResult;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.OptionBoolean;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.compat.InternalCompatibility;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringDoubleMap;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringIntegerMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.block.BlockInfo;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.EXPSource;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MMOCoreCompat
extends InternalCompatibility {
    private static boolean installed;
    public static Option<HashMap<String, Double>> MMOCORE_TRUNK_XP;
    public static Option<HashMap<String, Double>> MMOCORE_LEAVES_XP;
    public static Option<HashMap<String, Integer>> MMOCORE_REQUIRED_PROFESSION_LEVEL;
    public static Option<HashMap<String, Double>> MMOCORE_TREE_XP;
    public static OptionBoolean MMOCORE_EMULATE_REGEN;

    @Override
    public String getPluginName() {
        return "MMOCore";
    }

    @Override
    public void reload() {
        installed = this.isInstalled();
    }

    @Override
    public void fellTree(Block block, Player player, ItemStack axe, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks) {
        HashMap<String, Double> treeXp = MMOCORE_TREE_XP.get(tool, tree);
        if (treeXp == null || treeXp.isEmpty() || player == null) {
            return;
        }
        PlayerData data = PlayerData.get((OfflinePlayer)player);
        for (String profession : treeXp.keySet()) {
            int exp = this.convert(treeXp.get(profession));
            if (profession.equals("global")) {
                data.giveExperience((double)exp, EXPSource.SOURCE);
                continue;
            }
            data.getCollectionSkills().giveExperience(MMOCore.plugin.professionManager.get(profession), (double)exp, EXPSource.SOURCE);
        }
    }

    @Override
    public void breakBlock(Tree tree, Tool tool, Player player, ItemStack axe, Block block, List<Modifier> modifiers) {
        boolean doRegen;
        HashMap<String, Double> xp = null;
        if (tree.trunk.contains(block.getType())) {
            xp = MMOCORE_TRUNK_XP.get(tool, tree);
        } else if (tree.leaves.contains(block.getType())) {
            xp = MMOCORE_LEAVES_XP.get(tool, tree);
        }
        if (player != null && xp != null && !xp.isEmpty()) {
            PlayerData data = PlayerData.get((OfflinePlayer)player);
            if (xp.containsKey("global")) {
                data.giveExperience((double)this.convert(xp.get("global")), EXPSource.SOURCE);
            }
            for (String profession : xp.keySet()) {
                int exp = this.convert(xp.get(profession));
                if (profession.equals("global")) {
                    data.giveExperience((double)exp, EXPSource.SOURCE);
                    continue;
                }
                data.getCollectionSkills().giveExperience(MMOCore.plugin.professionManager.get(profession), (double)exp, EXPSource.SOURCE);
            }
        }
        if (doRegen = MMOCORE_EMULATE_REGEN.get(tool, tree).booleanValue()) {
            BlockInfo info = MMOCore.plugin.mineManager.getInfo(block);
            String savedData = block.getBlockData().getAsString();
            if (info != null && info.hasRegen()) {
                Bukkit.getScheduler().runTaskLater((Plugin)MMOCore.plugin, () -> MMOCore.plugin.mineManager.initialize(info.startRegeneration(Bukkit.createBlockData((String)savedData), block.getLocation()), true), 1L);
            }
        }
    }

    private int convert(double d) {
        int i = (int)d;
        double remainder = d - (double)i;
        Random random = new Random();
        if (random.nextDouble() < remainder) {
            ++i;
        }
        return i;
    }

    static {
        MMOCORE_TRUNK_XP = new Option<HashMap<String, Double>>("MMOCore Trunk XP", true, false, true, new HashMap(), (Object)"\n   - woodcutting: 1"){

            @Override
            public String getDesc(boolean ingame) {
                return "EXP will be provided to these professions when a tree is felled\nEXP is provided per-block (a value of 1 means 1 EXP per block of trunk)\nuse \"global\" to add global experience" + (ingame ? "" : "\nex:\n- global: 3\n- woodcutting: 8");
            }

            @Override
            public HashMap<String, Double> load(Object o) {
                if (o instanceof MemorySection) {
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    MemorySection m = (MemorySection)o;
                    for (String key : m.getKeys(false)) {
                        Double xp;
                        String profession = key;
                        if (profession == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + xp);
                            continue;
                        }
                        professions.put(profession, xp);
                    }
                    return professions;
                }
                if (o instanceof Map) {
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    Map m = (Map)o;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String profession = null;
                        if (obj instanceof String) {
                            profession = (String)obj;
                        }
                        if (profession == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + xp);
                            continue;
                        }
                        professions.put(profession, xp);
                    }
                    return professions;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    for (Object lbj : l) {
                        if (!(lbj instanceof Map)) continue;
                        Map m = (Map)lbj;
                        for (Object obj : m.keySet()) {
                            Double xp;
                            String profession = null;
                            if (obj instanceof String) {
                                profession = (String)obj;
                            }
                            if (profession == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                            if (professions.containsKey(profession)) {
                                professions.put(profession, professions.get(profession) + xp);
                                continue;
                            }
                            professions.put(profession, xp);
                        }
                    }
                    return professions;
                }
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public String writeToConfig(HashMap<String, Double> value) {
                if (value == null) {
                    return "";
                }
                String s = "{";
                String str = "";
                for (String st : value.keySet()) {
                    str = str + ", " + st + ": " + value.get(st);
                }
                if (!str.isEmpty()) {
                    s = s + str.substring(2);
                }
                return s + "}";
            }
        };
        MMOCORE_LEAVES_XP = new Option<HashMap<String, Double>>("MMOCore Leaves XP", true, false, true, new HashMap(), (Object)"\n   - woodcutting: 0"){

            @Override
            public String getDesc(boolean ingame) {
                return "EXP will be provided to these professions when a tree is felled\nEXP is provided per-block (a value of 1 means 1 EXP per block of leaves)\nuse \"global\" to add global experience" + (ingame ? "" : "\nex:\n- global: 3\n- woodcutting: 8");
            }

            @Override
            public HashMap<String, Double> load(Object o) {
                if (o instanceof MemorySection) {
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    MemorySection m = (MemorySection)o;
                    for (String key : m.getKeys(false)) {
                        Double xp;
                        String profession = key;
                        if (profession == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + xp);
                            continue;
                        }
                        professions.put(profession, xp);
                    }
                    return professions;
                }
                if (o instanceof Map) {
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    Map m = (Map)o;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String profession = null;
                        if (obj instanceof String) {
                            profession = (String)obj;
                        }
                        if (profession == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + xp);
                            continue;
                        }
                        professions.put(profession, xp);
                    }
                    return professions;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    for (Object lbj : l) {
                        if (!(lbj instanceof Map)) continue;
                        Map m = (Map)lbj;
                        for (Object obj : m.keySet()) {
                            Double xp;
                            String profession = null;
                            if (obj instanceof String) {
                                profession = (String)obj;
                            }
                            if (profession == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                            if (professions.containsKey(profession)) {
                                professions.put(profession, professions.get(profession) + xp);
                                continue;
                            }
                            professions.put(profession, xp);
                        }
                    }
                    return professions;
                }
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public String writeToConfig(HashMap<String, Double> value) {
                if (value == null) {
                    return "";
                }
                String s = "{";
                String str = "";
                for (String st : value.keySet()) {
                    str = str + ", " + st + ": " + value.get(st);
                }
                if (!str.isEmpty()) {
                    s = s + str.substring(2);
                }
                return s + "}";
            }
        };
        MMOCORE_REQUIRED_PROFESSION_LEVEL = new Option<HashMap<String, Integer>>("MMOCore Required Profession Level", true, true, true, null){

            @Override
            public String getDesc(boolean ingame) {
                return "These professions' levels will be checked before a tree is felled";
            }

            @Override
            public HashMap<String, Integer> load(Object o) {
                if (o instanceof MemorySection) {
                    HashMap<String, Integer> professions = new HashMap<String, Integer>();
                    MemorySection m = (MemorySection)o;
                    for (String key : m.getKeys(false)) {
                        Integer lvlreq;
                        String profession = key;
                        if (profession == null || (lvlreq = Option.loadInt(m.get(key))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + lvlreq);
                            continue;
                        }
                        professions.put(profession, lvlreq);
                    }
                    return professions;
                }
                if (o instanceof Map) {
                    HashMap<String, Integer> professions = new HashMap<String, Integer>();
                    Map m = (Map)o;
                    for (Object obj : m.keySet()) {
                        Integer lvlreq;
                        String profession = null;
                        if (obj instanceof String) {
                            profession = (String)obj;
                        }
                        if (profession == null || (lvlreq = Option.loadInt(m.get(obj))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + lvlreq);
                            continue;
                        }
                        professions.put(profession, lvlreq);
                    }
                    return professions;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<String, Integer> professions = new HashMap<String, Integer>();
                    for (Object lbj : l) {
                        if (!(lbj instanceof Map)) continue;
                        Map m = (Map)lbj;
                        for (Object obj : m.keySet()) {
                            Integer lvlreq;
                            String profession = null;
                            if (obj instanceof String) {
                                profession = (String)obj;
                            }
                            if (profession == null || (lvlreq = Option.loadInt(m.get(obj))) == null) continue;
                            if (professions.containsKey(profession)) {
                                professions.put(profession, professions.get(profession) + lvlreq);
                                continue;
                            }
                            professions.put(profession, lvlreq);
                        }
                    }
                    return professions;
                }
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<String, Integer> value) {
                return new ItemBuilder(Material.GOLDEN_PICKAXE);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringIntegerMap(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringIntegerMap(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringIntegerMap(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public String writeToConfig(HashMap<String, Integer> value) {
                if (value == null) {
                    return "";
                }
                String s = "{";
                String str = "";
                for (String st : value.keySet()) {
                    str = str + ", " + st + ": " + value.get(st);
                }
                if (!str.isEmpty()) {
                    s = s + str.substring(2);
                }
                return s + "}";
            }

            @Override
            protected DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int playerLevel;
                int lvl;
                HashMap lvlReqs;
                if (!installed) {
                    return null;
                }
                PlayerData data = PlayerData.get((OfflinePlayer)player);
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    for (String profession : ((HashMap)this.globalValue).keySet()) {
                        int lvl2 = (Integer)((HashMap)this.globalValue).get(profession);
                        int playerLevel2 = profession.equals("global") ? data.getLevel() : data.getCollectionSkills().getLevel(profession);
                        if (playerLevel2 >= lvl2) continue;
                        return new DebugResult(this, DebugResult.Type.GLOBAL, playerLevel2, lvl2, profession);
                    }
                }
                if ((lvlReqs = (HashMap)this.toolValues.get(tool)) != null) {
                    for (String profession : lvlReqs.keySet()) {
                        lvl = (Integer)lvlReqs.get(profession);
                        playerLevel = profession.equals("global") ? data.getLevel() : data.getCollectionSkills().getLevel(profession);
                        if (playerLevel >= lvl) continue;
                        return new DebugResult(this, DebugResult.Type.TOOL, playerLevel, lvl, profession);
                    }
                }
                if ((lvlReqs = (HashMap)this.treeValues.get(tree)) != null) {
                    for (String profession : lvlReqs.keySet()) {
                        lvl = (Integer)lvlReqs.get(profession);
                        playerLevel = profession.equals("global") ? data.getLevel() : data.getCollectionSkills().getLevel(profession);
                        if (playerLevel >= lvl) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, playerLevel, lvl, profession);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return Option.generateDebugText("Insufficient MMOCore profession level$: {2} - {0}<{1}", "All MMOCore profession requirements met");
            }
        };
        MMOCORE_TREE_XP = new Option<HashMap<String, Double>>("MMOCore Tree XP", true, false, true, new HashMap(), (Object)"\n   - woodcutting: 0"){

            @Override
            public String getDesc(boolean ingame) {
                return "EXP will be provided to these professions when a tree is felled\nEXP is provided per-tree (a value of 1 means 1 EXP per tree)\nuse \"global\" to add global experience" + (ingame ? "" : "\nex:\n- global: 3\n- woodcutting: 8");
            }

            @Override
            public HashMap<String, Double> load(Object o) {
                if (o instanceof MemorySection) {
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    MemorySection m = (MemorySection)o;
                    for (String key : m.getKeys(false)) {
                        Double xp;
                        String profession = key;
                        if (profession == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + xp);
                            continue;
                        }
                        professions.put(profession, xp);
                    }
                    return professions;
                }
                if (o instanceof Map) {
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    Map m = (Map)o;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String profession = null;
                        if (obj instanceof String) {
                            profession = (String)obj;
                        }
                        if (profession == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (professions.containsKey(profession)) {
                            professions.put(profession, professions.get(profession) + xp);
                            continue;
                        }
                        professions.put(profession, xp);
                    }
                    return professions;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<String, Double> professions = new HashMap<String, Double>();
                    for (Object lbj : l) {
                        if (!(lbj instanceof Map)) continue;
                        Map m = (Map)lbj;
                        for (Object obj : m.keySet()) {
                            Double xp;
                            String profession = null;
                            if (obj instanceof String) {
                                profession = (String)obj;
                            }
                            if (profession == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                            if (professions.containsKey(profession)) {
                                professions.put(profession, professions.get(profession) + xp);
                                continue;
                            }
                            professions.put(profession, xp);
                        }
                    }
                    return professions;
                }
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
                return new ItemBuilder(Material.JUNGLE_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public String writeToConfig(HashMap<String, Double> value) {
                if (value == null) {
                    return "";
                }
                String s = "{";
                String str = "";
                for (String st : value.keySet()) {
                    str = str + ", " + st + ": " + value.get(st);
                }
                if (!str.isEmpty()) {
                    s = s + str.substring(2);
                }
                return s + "}";
            }
        };
        MMOCORE_EMULATE_REGEN = new OptionBoolean("MMOCore Emulate Regen", true, false, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Toggle emulating MMOCore's Block Regen" + (ingame ? "" : " (see MMOCore/professions/mining.yml)\nMMOCore's \"temp-block\" option must not be set, otherwise tree will not fell\n");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.DARK_OAK_SAPLING);
            }
        };
    }
}

