/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.compat;

import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.compat.InternalCompatibility;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringDoubleMap;
import com.willfp.ecoskills.api.EcoSkillsAPI;
import com.willfp.ecoskills.skills.Skill;
import com.willfp.ecoskills.skills.Skills;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EcoSkillsCompat
extends InternalCompatibility {
    public static Option<HashMap<String, Double>> ECOSKILLS_TRUNK_XP = new Option<HashMap<String, Double>>("EcoSkills Trunk XP", true, false, true, new HashMap(), (Object)"\n   - Woodcutting: 1"){

        @Override
        public String getDesc(boolean ingame) {
            return "EXP will be provided to these skills when a tree is felled\nEXP is provided per-block (a value of 1 means 1 EXP per block of trunk)";
        }

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String skill = key;
                    if (skill == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof Map) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String skill = null;
                    if (obj instanceof String) {
                        skill = (String)obj;
                    }
                    if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> skills = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String skill = null;
                        if (obj instanceof String) {
                            skill = (String)obj;
                        }
                        if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (skills.containsKey(skill)) {
                            skills.put(skill, skills.get(skill) + xp);
                            continue;
                        }
                        skills.put(skill, xp);
                    }
                }
                return skills;
            }
            return null;
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.OAK_LOG);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public String writeToConfig(HashMap<String, Double> value) {
            if (value == null) {
                return "";
            }
            String s = "{";
            String str = "";
            for (String st : value.keySet()) {
                str = str + ", " + st + ": " + value.get(st);
            }
            if (!str.isEmpty()) {
                s = s + str.substring(2);
            }
            return s + "}";
        }
    };
    public static Option<HashMap<String, Double>> ECOSKILLS_LEAVES_XP = new Option<HashMap<String, Double>>("EcoSkills Leaves XP", true, false, true, new HashMap(), (Object)"\n   - woodcutting: 0"){

        @Override
        public String getDesc(boolean ingame) {
            return "EXP will be provided to these skills when a tree is felled\nEXP is provided per-block (a value of 1 means 1 EXP per block of leaves)\nuse \"global\" to add global experience" + (ingame ? "" : "\nex:\n- global: 3\n- woodcutting: 8");
        }

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String skill = key;
                    if (skill == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof Map) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String skill = null;
                    if (obj instanceof String) {
                        skill = (String)obj;
                    }
                    if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> skills = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String skill = null;
                        if (obj instanceof String) {
                            skill = (String)obj;
                        }
                        if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (skills.containsKey(skill)) {
                            skills.put(skill, skills.get(skill) + xp);
                            continue;
                        }
                        skills.put(skill, xp);
                    }
                }
                return skills;
            }
            return null;
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.OAK_LEAVES);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public String writeToConfig(HashMap<String, Double> value) {
            if (value == null) {
                return "";
            }
            String s = "{";
            String str = "";
            for (String st : value.keySet()) {
                str = str + ", " + st + ": " + value.get(st);
            }
            if (!str.isEmpty()) {
                s = s + str.substring(2);
            }
            return s + "}";
        }
    };
    public static Option<HashMap<String, Double>> ECOSKILLS_TREE_XP = new Option<HashMap<String, Double>>("EcoSkills Tree XP", true, false, true, new HashMap(), (Object)"\n   - woodcutting: 0"){

        @Override
        public String getDesc(boolean ingame) {
            return "EXP will be provided to these skills when a tree is felled\nEXP is provided per-tree (a value of 1 means 1 EXP per tree)\nuse \"global\" to add global experience" + (ingame ? "" : "\nex:\n- global: 3\n- woodcutting: 8");
        }

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String skill = key;
                    if (skill == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof Map) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String skill = null;
                    if (obj instanceof String) {
                        skill = (String)obj;
                    }
                    if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> skills = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String skill = null;
                        if (obj instanceof String) {
                            skill = (String)obj;
                        }
                        if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (skills.containsKey(skill)) {
                            skills.put(skill, skills.get(skill) + xp);
                            continue;
                        }
                        skills.put(skill, xp);
                    }
                }
                return skills;
            }
            return null;
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.JUNGLE_LOG);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public String writeToConfig(HashMap<String, Double> value) {
            if (value == null) {
                return "";
            }
            String s = "{";
            String str = "";
            for (String st : value.keySet()) {
                str = str + ", " + st + ": " + value.get(st);
            }
            if (!str.isEmpty()) {
                s = s + str.substring(2);
            }
            return s + "}";
        }
    };

    @Override
    public String getPluginName() {
        return "EcoSkills";
    }

    @Override
    public void fellTree(Block block, Player player, ItemStack axe, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks) {
        if (player == null) {
            return;
        }
        HashMap<String, Double> treeXp = ECOSKILLS_TREE_XP.get(tool, tree);
        if (treeXp == null || treeXp.isEmpty()) {
            return;
        }
        for (String skill : treeXp.keySet()) {
            EcoSkillsAPI.gainSkillXP((OfflinePlayer)player, (Skill)((Skill)Skills.INSTANCE.getByID(skill)), (double)treeXp.get(skill));
        }
    }

    @Override
    public void breakBlock(Tree tree, Tool tool, Player player, ItemStack axe, Block block, List<Modifier> modifiers) {
        if (player == null) {
            return;
        }
        HashMap<String, Double> xp = null;
        if (tree.trunk.contains(block.getType())) {
            xp = ECOSKILLS_TRUNK_XP.get(tool, tree);
        } else if (tree.leaves.contains(block.getType())) {
            xp = ECOSKILLS_LEAVES_XP.get(tool, tree);
        }
        if (xp != null && !xp.isEmpty()) {
            for (String skill : xp.keySet()) {
                EcoSkillsAPI.gainSkillXP((OfflinePlayer)player, (Skill)((Skill)Skills.INSTANCE.getByID(skill)), (double)xp.get(skill));
            }
        }
    }
}

