/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.compat;

import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.OptionBoolean;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.compat.InternalCompatibility;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringDoubleMap;
import com.willfp.ecojobs.api.EcoJobsAPI;
import com.willfp.ecojobs.jobs.Job;
import com.willfp.ecojobs.jobs.Jobs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EcoJobsCompat
extends InternalCompatibility {
    public static Option<HashMap<String, Double>> ECOJOBS_TRUNK_XP = new Option<HashMap<String, Double>>("EcoJobs Trunk XP", true, true, true, null){

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> jobs = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String job = key;
                    if (job == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (jobs.containsKey(job)) {
                        jobs.put(job, jobs.get(job) + xp);
                        continue;
                    }
                    jobs.put(job, xp);
                }
                return jobs;
            }
            if (o instanceof Map) {
                HashMap<String, Double> jobs = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String job = null;
                    if (obj instanceof String) {
                        job = (String)obj;
                    }
                    if (job == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (jobs.containsKey(job)) {
                        jobs.put(job, jobs.get(job) + xp);
                        continue;
                    }
                    jobs.put(job, xp);
                }
                return jobs;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> jobs = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String job = null;
                        if (obj instanceof String) {
                            job = (String)obj;
                        }
                        if (job == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (jobs.containsKey(job)) {
                            jobs.put(job, jobs.get(job) + xp);
                            continue;
                        }
                        jobs.put(job, xp);
                    }
                }
                return jobs;
            }
            return null;
        }

        @Override
        public String getDesc(boolean ingame) {
            return "How much Job experience should be given per block of trunk felled?";
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.OAK_LOG);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public HashMap<String, Double> get(Tool tool, Tree tree) {
            HashMap vals;
            HashMap<String, Double> val = new HashMap<String, Double>();
            if (this.globalValue != null) {
                val.putAll((Map)this.globalValue);
            }
            if ((vals = (HashMap)this.toolValues.get(tool)) != null) {
                for (String job : vals.keySet()) {
                    val.put(job, val.getOrDefault(job, 0.0) + (Double)vals.get(job));
                }
            }
            if ((vals = (HashMap)this.treeValues.get(tree)) != null) {
                for (String job : vals.keySet()) {
                    val.put(job, val.getOrDefault(job, 0.0) + (Double)vals.get(job));
                }
            }
            return val;
        }
    };
    public static Option<HashMap<String, Double>> ECOJOBS_LEAF_XP = new Option<HashMap<String, Double>>("EcoJobs Leaf XP", true, true, true, null){

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> jobs = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String job = key;
                    if (job == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (jobs.containsKey(job)) {
                        jobs.put(job, jobs.get(job) + xp);
                        continue;
                    }
                    jobs.put(job, xp);
                }
                return jobs;
            }
            if (o instanceof Map) {
                HashMap<String, Double> jobs = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String job = null;
                    if (obj instanceof String) {
                        job = (String)obj;
                    }
                    if (job == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (jobs.containsKey(job)) {
                        jobs.put(job, jobs.get(job) + xp);
                        continue;
                    }
                    jobs.put(job, xp);
                }
                return jobs;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> jobs = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String job = null;
                        if (obj instanceof String) {
                            job = (String)obj;
                        }
                        if (job == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (jobs.containsKey(job)) {
                            jobs.put(job, jobs.get(job) + xp);
                            continue;
                        }
                        jobs.put(job, xp);
                    }
                }
                return jobs;
            }
            return null;
        }

        @Override
        public String getDesc(boolean ingame) {
            return "How much Job experience should be given per block of leaves felled?";
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.OAK_LEAVES);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public HashMap<String, Double> get(Tool tool, Tree tree) {
            HashMap vals;
            HashMap<String, Double> val = new HashMap<String, Double>();
            if (this.globalValue != null) {
                val.putAll((Map)this.globalValue);
            }
            if ((vals = (HashMap)this.toolValues.get(tool)) != null) {
                for (String job : vals.keySet()) {
                    val.put(job, val.getOrDefault(job, 0.0) + (Double)vals.get(job));
                }
            }
            if ((vals = (HashMap)this.treeValues.get(tree)) != null) {
                for (String job : vals.keySet()) {
                    val.put(job, val.getOrDefault(job, 0.0) + (Double)vals.get(job));
                }
            }
            return val;
        }
    };
    public static OptionBoolean ECOJOBS_APPLY_MULTIPLIERS = new OptionBoolean("EcoJobs Apply Multipliers", true, true, true, true){

        @Override
        public String getDesc(boolean ingame) {
            return "Should EcoJobs multipliers be applied to experience earned through TreeFeller?";
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(Boolean value) {
            return new ItemBuilder(Material.GLISTERING_MELON_SLICE);
        }
    };

    @Override
    public String getPluginName() {
        return "EcoJobs";
    }

    @Override
    public void breakBlock(Tree tree, Tool tool, Player player, ItemStack axe, Block block, List<Modifier> modifiers) {
        Job job2;
        if (player == null) {
            return;
        }
        HashMap<Job, Double> exp = new HashMap<Job, Double>();
        if (tree.trunk.contains(block.getType())) {
            HashMap<String, Double> trunk = ECOJOBS_TRUNK_XP.get(tool, tree);
            for (String key : trunk.keySet()) {
                job2 = Jobs.getByID((String)key);
                exp.put(job2, exp.getOrDefault(job2, 0.0) + trunk.get(key));
            }
        } else if (tree.leaves.contains(block.getType())) {
            HashMap<String, Double> leaves = ECOJOBS_LEAF_XP.get(tool, tree);
            for (String key : leaves.keySet()) {
                job2 = Jobs.getByID((String)key);
                exp.put(job2, exp.getOrDefault(job2, 0.0) + leaves.get(key));
            }
        }
        boolean applyMultipliers = ECOJOBS_APPLY_MULTIPLIERS.get(tool, tree);
        EcoJobsAPI api = EcoJobsAPI.instance;
        for (Job job2 : exp.keySet()) {
            if ((Double)exp.get(job2) == 0.0) continue;
            api.giveJobExperience(player, job2, ((Double)exp.get(job2)).doubleValue(), applyMultipliers);
        }
    }
}

