/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller.compat;

import com.archyx.aureliumskills.api.AureliumAPI;
import com.archyx.aureliumskills.skills.Skill;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.OptionBoolean;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.compat.InternalCompatibility;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringDoubleMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AureliumSkillsCompat
extends InternalCompatibility {
    public static Option<HashMap<String, Double>> AURELIUMSKILLS_TRUNK_XP = new Option<HashMap<String, Double>>("AureliumSkills Trunk XP", true, false, true, new HashMap(), (Object)"\n   - foraging: 1"){

        @Override
        public String getDesc(boolean ingame) {
            return "EXP will be provided to these skills when a tree is felled\nEXP is provided per-block (a value of 1 means 1 EXP per block of trunk)" + (ingame ? "" : "\nex:\n- foraging: 8");
        }

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String skill = key;
                    if (skill == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof Map) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String skill = null;
                    if (obj instanceof String) {
                        skill = (String)obj;
                    }
                    if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> skills = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String skill = null;
                        if (obj instanceof String) {
                            skill = (String)obj;
                        }
                        if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (skills.containsKey(skill)) {
                            skills.put(skill, skills.get(skill) + xp);
                            continue;
                        }
                        skills.put(skill, xp);
                    }
                }
                return skills;
            }
            return null;
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.OAK_LOG);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public String writeToConfig(HashMap<String, Double> value) {
            if (value == null) {
                return "";
            }
            String s = "{";
            String str = "";
            for (String st : value.keySet()) {
                str = str + ", " + st + ": " + value.get(st);
            }
            if (!str.isEmpty()) {
                s = s + str.substring(2);
            }
            return s + "}";
        }
    };
    public static Option<HashMap<String, Double>> AURELIUMSKILLS_LEAVES_XP = new Option<HashMap<String, Double>>("AureliumSkills Leaves XP", true, false, true, new HashMap(), (Object)"\n   - foraging: 0"){

        @Override
        public String getDesc(boolean ingame) {
            return "EXP will be provided to these skills when a tree is felled\nEXP is provided per-block (a value of 1 means 1 EXP per block of leaves)" + (ingame ? "" : "\nex:\n- foraging: 8");
        }

        @Override
        public HashMap<String, Double> load(Object o) {
            if (o instanceof MemorySection) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                MemorySection m = (MemorySection)o;
                for (String key : m.getKeys(false)) {
                    Double xp;
                    String skill = key;
                    if (skill == null || (xp = Option.loadDouble(m.get(key))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof Map) {
                HashMap<String, Double> skills = new HashMap<String, Double>();
                Map m = (Map)o;
                for (Object obj : m.keySet()) {
                    Double xp;
                    String skill = null;
                    if (obj instanceof String) {
                        skill = (String)obj;
                    }
                    if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                    if (skills.containsKey(skill)) {
                        skills.put(skill, skills.get(skill) + xp);
                        continue;
                    }
                    skills.put(skill, xp);
                }
                return skills;
            }
            if (o instanceof List) {
                List l = (List)o;
                HashMap<String, Double> skills = new HashMap<String, Double>();
                for (Object lbj : l) {
                    if (!(lbj instanceof Map)) continue;
                    Map m = (Map)lbj;
                    for (Object obj : m.keySet()) {
                        Double xp;
                        String skill = null;
                        if (obj instanceof String) {
                            skill = (String)obj;
                        }
                        if (skill == null || (xp = Option.loadDouble(m.get(obj))) == null) continue;
                        if (skills.containsKey(skill)) {
                            skills.put(skill, skills.get(skill) + xp);
                            continue;
                        }
                        skills.put(skill, xp);
                    }
                }
                return skills;
            }
            return null;
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(HashMap<String, Double> value) {
            return new ItemBuilder(Material.OAK_LEAVES);
        }

        @Override
        public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, false, false, (HashMap)this.globalValue, value -> {
                this.globalValue = value;
            }));
        }

        @Override
        public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.toolValues.get(tool), value -> {
                if (value == null) {
                    this.toolValues.remove(tool);
                } else {
                    this.toolValues.put(tool, value);
                }
            }));
        }

        @Override
        public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
            parent.open(new MenuModifyStringDoubleMap(parent, parent.plugin, parent.player, this.name, 0.0, Double.MAX_VALUE, true, false, (HashMap)this.treeValues.get(tree), value -> {
                if (value == null) {
                    this.treeValues.remove(tree);
                } else {
                    this.treeValues.put(tree, value);
                }
            }));
        }

        @Override
        public String writeToConfig(HashMap<String, Double> value) {
            if (value == null) {
                return "";
            }
            String s = "{";
            String str = "";
            for (String st : value.keySet()) {
                str = str + ", " + st + ": " + value.get(st);
            }
            if (!str.isEmpty()) {
                s = s + str.substring(2);
            }
            return s + "}";
        }
    };
    public static OptionBoolean AURELIUMSKILLS_APPLY_MODIFIERS = new OptionBoolean("AureliumSkills Apply Modifiers", true, true, true, true){

        @Override
        public String getDesc(boolean ingame) {
            return "Should AureliumSkills modifiers be applied to experience earned through TreeFeller?";
        }

        @Override
        public ItemBuilder getConfigurationDisplayItem(Boolean value) {
            return new ItemBuilder(Material.EXPERIENCE_BOTTLE);
        }
    };
    private BukkitTask pendingTask = null;
    private TreeFeller treefeller;
    private HashMap<Player, HashMap<Skill, Double>> modsMap = new HashMap();
    private HashMap<Player, HashMap<Skill, Double>> noModsMap = new HashMap();

    @Override
    public String getPluginName() {
        return "AureliumSkills";
    }

    @Override
    public void init(TreeFeller treefeller) {
        this.treefeller = treefeller;
    }

    @Override
    public void breakBlock(Tree tree, Tool tool, Player player, ItemStack axe, Block block, List<Modifier> modifiers) {
        if (player == null) {
            return;
        }
        HashMap<String, Double> xp = null;
        if (tree.trunk.contains(block.getType())) {
            xp = AURELIUMSKILLS_TRUNK_XP.get(tool, tree);
        } else if (tree.leaves.contains(block.getType())) {
            xp = AURELIUMSKILLS_LEAVES_XP.get(tool, tree);
        }
        if (xp == null || xp.isEmpty()) {
            return;
        }
        boolean applyMods = AURELIUMSKILLS_APPLY_MODIFIERS.get(tool, tree);
        for (String key : xp.keySet()) {
            double amount = xp.get(key);
            Skill skill = AureliumAPI.getPlugin().getSkillRegistry().getSkill(key);
            if (skill == null) continue;
            HashMap<Player, HashMap<Skill, Double>> map = null;
            map = applyMods ? this.modsMap : this.noModsMap;
            if (!map.containsKey(player)) {
                map.put(player, new HashMap());
            }
            HashMap<Skill, Double> mp = map.get(player);
            mp.put(skill, mp.getOrDefault(skill, 0.0) + amount);
        }
        if (this.pendingTask == null) {
            this.pendingTask = new BukkitRunnable(){

                public void run() {
                    HashMap map;
                    AureliumSkillsCompat.this.pendingTask = null;
                    for (Player p : AureliumSkillsCompat.this.noModsMap.keySet()) {
                        map = (HashMap)AureliumSkillsCompat.this.noModsMap.get(p);
                        for (Skill skill : map.keySet()) {
                            AureliumAPI.addXpRaw((Player)p, (Skill)skill, (double)((Double)map.get(skill)));
                        }
                    }
                    AureliumSkillsCompat.this.noModsMap.clear();
                    for (Player p : AureliumSkillsCompat.this.modsMap.keySet()) {
                        map = (HashMap)AureliumSkillsCompat.this.modsMap.get(p);
                        for (Skill skill : map.keySet()) {
                            AureliumAPI.addXp((Player)p, (Skill)skill, (double)((Double)map.get(skill)));
                        }
                    }
                    AureliumSkillsCompat.this.modsMap.clear();
                }
            }.runTaskLater((Plugin)this.treefeller, Option.CUTTING_ANIMATION.get(tool, tree) == true ? 10L : 1L);
        }
    }
}

